% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds-group-summary.R
\name{ds_group_summary}
\alias{ds_group_summary}
\alias{plot.ds_group_summary}
\title{Groupwise descriptive statistics}
\usage{
ds_group_summary(data, group_by, cols)

\method{plot}{ds_group_summary}(x, print_plot = TRUE, ...)
}
\arguments{
\item{data}{A \code{data.frame} or a \code{tibble}.}

\item{group_by}{Column in \code{data}.}

\item{cols}{Column in \code{data}.}

\item{x}{An object of the class \code{ds_group_summary}.}

\item{print_plot}{logical; if \code{TRUE}, prints the plot else returns a plot object.}

\item{...}{Further arguments to be passed to or from methods.}
}
\value{
\code{ds_group_summary()} returns an object of class \code{"ds_group_summary"}.
An object of class \code{"ds_group_summary"} is a list containing the
following components:

\item{stats}{A data frame containing descriptive statistics for the different
levels of the factor variable.}
\item{tidy_stats}{A tibble containing descriptive statistics for the different
levels of the factor variable.}
\item{plotdata}{Data for boxplot method.}
}
\description{
Descriptive statistics of a continuous variable for the different levels of
a categorical variable. \code{boxplot.group_summary()} creates boxplots of
the continuous variable for the different levels of the categorical variable.
}
\examples{
# ds_group summary
ds_group_summary(mtcarz, cyl, mpg)

# boxplot
k <- ds_group_summary(mtcarz, cyl, mpg)
plot(k)

# tibble
k$tidy_stats

}
\seealso{
\code{\link{ds_summary_stats}}
}
