% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permute_subgroups.R
\name{form_homogeneous_subgroups}
\alias{form_homogeneous_subgroups}
\title{Form groups and subgroups of 'homogeneous' samples as defined by certain variables and size constraints}
\usage{
form_homogeneous_subgroups(
  batch_container,
  allocate_var,
  keep_together_vars = c(),
  n_min = NA,
  n_max = NA,
  n_ideal = NA,
  subgroup_var_name = NULL,
  prefer_big_groups = TRUE,
  strict = TRUE
)
}
\arguments{
\item{batch_container}{Batch container with all samples assigned that are to be grouped and sub-grouped}

\item{allocate_var}{Name of a variable in the \code{samples} table to inform possible groupings, as (sub)group sizes must add up to the correct totals}

\item{keep_together_vars}{Vector of column names in sample table; groups are formed by pooling samples with identical values of all those variables}

\item{n_min}{Minimal number of samples in one sub(!)group; by default 1}

\item{n_max}{Maximal number of samples in one sub(!)group; by default the size of the biggest group}

\item{n_ideal}{Ideal number of samples in one sub(!)group; by default the floor or ceiling of \code{mean(n_min,n_max)}, depending on the setting of \code{prefer_big_groups}}

\item{subgroup_var_name}{An optional column name for the subgroups which are formed (or NULL)}

\item{prefer_big_groups}{Boolean; indicating whether or not bigger subgroups should be preferred in case of several possibilities}

\item{strict}{Boolean; if TRUE, subgroup size constraints have to be met strictly, implying the possibility of finding no solution at all}
}
\value{
Subgroup object to be used in subsequent calls to \code{compile_possible_subgroup_allocation()}
}
\description{
Form groups and subgroups of 'homogeneous' samples as defined by certain variables and size constraints
}
