#' Example meta-analysis: Truncated Normal Data
#'
#' This dataset is generated by truncated normal data with function \code{rtruncnorm} with the scale of 0-4.
#'
#' @format A data frame with 40 studies:
#' \describe{
#'   \item{study}{No of studies}
#'   \item{n1}{sample size of group 1 with equal sample size for the two studies. Generated with uniform distribution.}
#'   \item{m1}{mean of group 1. Population mean is equal to 1. The data of group 1 is generated with the scale 0-4. }
#'   \item{sd1}{standard deviation of group 1. Population sd of group 1 is equal to 1. }
#'   \item{lo1}{minimum of the generated sample for group 1. }
#'   \item{hi1}{maximum of the generated sample for group 1. }
#'   \item{n2}{sample size of study 2; n1 = n2 for each study}
#'   \item{m2}{mean of group 2. Population mean is equal to 1.5. The data of group 2 is generated with the scale 0-4. }
#'   \item{sd2}{standard deviation of group 2. Population sd of group 2 is equal to 1. }
#'   \item{lo2}{minimum of the generated sample for group 2. }
#'   \item{hi2}{maximum of the generated sample for group 2. }
#'   \item{skew1}{sample skewness for group 1. }
#'   \item{skew2}{sammple skewness for group 2. }
#' }
#'
"trun_mdat"
