# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @rdname diff
#'
#' @param cleanup Determines the cleanup method applied to the diffs. Allowed values include:
#' `semantic`, `lossless`, `efficiency`, `merge` and `none`. See Details for the behavior of 
#' these methods.
#' @param checklines Performance flag - if `FALSE`, then don't run a
#' line-level diff first to identify the changed areas.
#' If `TRUE`, run a faster slightly less optimal diff. Default: `TRUE`.
#' 
#' @details
#' ## Cleanup methods
#' 
#' * `semantic` - Reduce the number of edits by eliminating semantically trivial equalities.
#' * semantic `lossless` - Look for single edits surrounded on both sides by equalities
#'   which can be shifted sideways to align the edit to a word boundary.
#'   e.g: The c**at c**ame. -> The **cat **came.
#' * `efficiency` - Reduce the number of edits by eliminating operationally trivial equalities.
#' * `merge` - Reorder and merge like edit sections.  Merge equalities.
#'   Any edit section can move as long as it doesn't cross an equality.
#' * `none` - Do not apply any cleanup methods to the diffs.
#'
#' @return * `diff_make()` returns a `diff_df` data frame containing the diffs.
#'
#' @export
diff_make <- function(x, y, cleanup = "semantic", checklines = TRUE) {
    .Call(`_diffmatchpatch_diff_make`, x, y, cleanup, checklines)
}

#' @rdname diff
#' @return * `diff_make()` returns the Levenshtein distance as an integer.
#' @export
diff_levenshtein <- function(diff) {
    .Call(`_diffmatchpatch_diff_levenshtein`, diff)
}

#' @rdname diff
#' @return * `diff_to_delta()` returns an character string.
#' @export
diff_to_delta <- function(diff) {
    .Call(`_diffmatchpatch_diff_to_delta`, diff)
}

#' @rdname diff
#' @return * `diff_from_delta()` returns a `diff_df` data frame.
#' @export
diff_from_delta <- function(x, delta) {
    .Call(`_diffmatchpatch_diff_from_delta`, x, delta)
}

#' @rdname diff
#' @return * `diff_to_html()` returns a character string.
#' @export
diff_to_html <- function(diff) {
    .Call(`_diffmatchpatch_diff_to_html`, diff)
}

#' @rdname diff
#' @return * `diff_to_patch()` returns a character string.
#' @export
diff_to_patch <- function(diff) {
    .Call(`_diffmatchpatch_diff_to_patch`, diff)
}

#' @rdname diff
#' @return * `diff_text_source()` returns a character string.
#' @export
diff_text_source <- function(diff) {
    .Call(`_diffmatchpatch_diff_text_source`, diff)
}

#' @rdname diff
#' @return * `diff_text_dest()` returns a character string.
#' @export
diff_text_dest <- function(diff) {
    .Call(`_diffmatchpatch_diff_text_dest`, diff)
}

#' @rdname match
#'
#' @description Locate the best instance of `pattern` in the `text` near `loc` using the
#' Bitap algorithm.Returns `-1` if no match found. Assumes R's typical 1-based indexing for `loc` 
#' and the returned value.
#'
#' This algorithm makes use of the `match_distance` and `match_threshold` options to determine 
#' the match. If these values are not set explicitly via the `threshold` and `distance` arguments - 
#' their value will use the currently set global option value.
#'
#' Candidate matches are scored based on: 
#' a) the number of spelling differences between the pattern and the text and 
#' b) the distance between the candidate match and the expected location. 
#' 
#' The `match_distance` option determines the relative importance of these two metrics.
#' 
#' @param text The text to search.
#' @param pattern The pattern to search for.
#' @param loc The expected location of the pattern.
#' @param threshold Threshold for determining a match (0 - perfect match, 1 - very loose).
#' @param distance Distance from expected location scaling for score penalty.
#' 
#' @return Index of best match or -1 for no match.
#' 
#' @export
match_find <- function(text, pattern, loc = 1L, threshold = NULL, distance = NULL) {
    .Call(`_diffmatchpatch_match_find`, text, pattern, loc, threshold, distance)
}

get_options <- function() {
    .Call(`_diffmatchpatch_get_options`)
}

set_options <- function(opts) {
    invisible(.Call(`_diffmatchpatch_set_options`, opts))
}

#' @rdname patch
#' @return `patch_make()` returns a string representation of the patch(es).
#' @export
patch_make <- function(x, y) {
    .Call(`_diffmatchpatch_patch_make`, x, y)
}

#' @rdname patch
#' @return * `patch_apply()` returns the patched version of the string `x`, 
#' the `matches` attribute contains logical values indicating which patches 
#' were successfully applied.
#' @export
patch_apply <- function(x, patch) {
    .Call(`_diffmatchpatch_patch_apply`, x, patch)
}

