% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/diff.R
\name{diff_make}
\alias{diff_make}
\alias{diff_levenshtein}
\alias{diff_to_delta}
\alias{diff_from_delta}
\alias{diff_to_html}
\alias{diff_to_patch}
\alias{diff_text_source}
\alias{diff_text_dest}
\alias{diff}
\title{Compute diffs between text strings}
\usage{
diff_make(x, y, cleanup = "semantic", checklines = TRUE)

diff_levenshtein(diff)

diff_to_delta(diff)

diff_from_delta(x, delta)

diff_to_html(diff)

diff_to_patch(diff)

diff_text_source(diff)

diff_text_dest(diff)
}
\arguments{
\item{x}{The source string}

\item{y}{The destination string}

\item{cleanup}{Determines the cleanup method applied to the diffs. Allowed values include:
\code{semantic}, \code{lossless}, \code{efficiency}, \code{merge} and \code{none}. See Details for the behavior of
these methods.}

\item{checklines}{Performance flag - if \code{FALSE}, then don't run a
line-level diff first to identify the changed areas.
If \code{TRUE}, run a faster slightly less optimal diff. Default: \code{TRUE}.}

\item{diff}{A \code{diff_df} data frame.}

\item{delta}{A delta string.}
}
\value{
\itemize{
\item \code{diff_make()} returns a \code{diff_df} data frame containing the diffs.
}

\itemize{
\item \code{diff_make()} returns the Levenshtein distance as an integer.
}

\itemize{
\item \code{diff_to_delta()} returns an character string.
}

\itemize{
\item \code{diff_from_delta()} returns a \code{diff_df} data frame.
}

\itemize{
\item \code{diff_to_html()} returns a character string.
}

\itemize{
\item \code{diff_to_patch()} returns a character string.
}

\itemize{
\item \code{diff_text_source()} returns a character string.
}

\itemize{
\item \code{diff_text_dest()} returns a character string.
}
}
\description{
The following functions are used to construct or work with diff(s) between text strings.
Specifically, \code{diff_make()} computes the character level differences between
the source string (\code{x}) and destination string (\code{y}). These diffs can be made more human
friendly via a secondary cleaning process via the \code{cleanup} argument.

Once computed, diffs are represented using \code{diff_df} data frames, which consist of just
two columns: \code{text} and \code{op}. Basic convenience functions for pretty printing of these are
provided by the package.

The following helper functions are provided:
\itemize{
\item \code{print()} - prints a diff using ANSI colors if available.
\item \code{as.character()} - converts a diff (using ANSI colors if available) to a character vector.
\item \code{diff_levenshtein()} calculates the Levenshtein distance of a diff.
\item \code{diff_to_delta()} converts a diff to a delta string.
\item \code{diff_from_delta()} creates a diff from a source string (\code{x}) and a \code{delta} string.
\item \code{diff_to_html()} converts a diff to pretty HTML string.
\item \code{diff_to_patch()} converts a diff to a patch string.
\item \code{diff_text_source()} recovers the source string from a diff.
\item \code{diff_text_dest()} recovers the destination string from a diff.
}
}
\details{
\subsection{Cleanup methods}{
\itemize{
\item \code{semantic} - Reduce the number of edits by eliminating semantically trivial equalities.
\item semantic \code{lossless} - Look for single edits surrounded on both sides by equalities
which can be shifted sideways to align the edit to a word boundary.
e.g: The c\strong{at c}ame. -> The **cat **came.
\item \code{efficiency} - Reduce the number of edits by eliminating operationally trivial equalities.
\item \code{merge} - Reorder and merge like edit sections.  Merge equalities.
Any edit section can move as long as it doesn't cross an equality.
\item \code{none} - Do not apply any cleanup methods to the diffs.
}
}
}
\examples{
(d = diff_make("abcdef", "abchij"))

diff_levenshtein(d)

diff_to_html(d)

diff_text_source(d) 

diff_text_dest(d) 

diff_to_patch(d)

(delta = diff_to_delta(d))

diff_from_delta("abcdef", delta)
}
