% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{dmp_options}
\alias{dmp_options}
\title{diffmatchpatch settings}
\usage{
dmp_options(...)
}
\arguments{
\item{...}{No arguments returns all current options and their values. Character values retrieve a subset
of options and the current values. Options can be set, using name = value. However, only the options named
below are used. Options can also be passed by giving a single unnamed argument which is a named list.}
}
\value{
When getting options returns a named list of options and their current values,
when setting options returns a named list of the previous value(s).
}
\description{
Allows for examining or setting options that affect the behavior of the
diff, match, and patch related functions in this package.
}
\details{
\subsection{Available options}{
\itemize{
\item \code{diff_timeout} (float) - Number of seconds to map a diff before giving up (0 for infinity).
\item \code{diff_edit_cost} (int) - Cost of an empty edit operation in terms of edit characters.
\item \code{match_threshold} (float) - At what point is no match declared (0.0 = perfection, 1.0 = very loose).
\item \code{match_distance} (int) - How far to search for a match (0 = exact location, 1000+ = broad match).
A match this many characters away from the expected location will add
1.0 to the score (0.0 is a perfect match).
\item \code{patch_delete_threshold} (float) - When deleting a large block of text (over ~64 characters), how close does
the contents have to match the expected contents. (0.0 = perfection,
1.0 = very loose).  Note that Match_Threshold controls how closely the
end points of a delete need to match.
\item \code{patch_margin} (int) - Chunk size for context length.
\item \code{match_max_bits} (int) - The number of bits in an int.
}
}
}
\examples{
dmp_options()

dmp_options("diff_timeout")

prev = dmp_options(diff_timeout = 5)
prev

}
