% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiscSurvDataTransform.R
\name{contToDisc}
\alias{contToDisc}
\title{Continuous to Discrete Transformation}
\usage{
contToDisc(
  dataShort,
  timeColumn,
  intervalLimits,
  equi = FALSE,
  timeAsFactor = FALSE
)
}
\arguments{
\item{dataShort}{Original data in short format ("class data.frame").}

\item{timeColumn}{Name of the column of discrete survival times ("character vector").}

\item{intervalLimits}{Right interval borders ("numeric vector"), e. g. if
the intervals are [0, a_1), [a_1, a_2), [a_2, a_max), then intervalLimits =
c(a_1, a_2, a_max)}

\item{equi}{Specifies if argument \emph{intervalLimits} should be interpreted as
number of equidistant intervals ("logical vector").}

\item{timeAsFactor}{Specifies if the computed discrete time intervals should be 
converted to a categorical variable ("logical vector"). Default is FALSE. 
In the default settings the discret time intervals are treated 
as quantitative ("numeric vector").}
}
\value{
Gives the data set expanded with a first column "timeDisc". This
column includes the discrete time intervals ("class factor").
}
\description{
Discretizes continuous time variable into a specified grid of censored data
for discrete survival analysis. It is a data preprocessing step, before the
data can be extendend in long format and further analysed with discrete
survival models.
}
\note{
In discrete survival analysis the survival times have to be
categorized in time intervals. Therefore this function is required, if there
are observed continuous survival times.
}
\examples{

# Example copenhagen stroke study data
library(pec)
data(cost)
head(cost)

# Convert observed times to months
# Right borders of intervals [0, a_1), [a_1, a_2), ... , [a_{\\max-1}, a_{\\max})
IntBorders <- 1:ceiling(max(cost$time)/30)*30

# Select subsample
subCost <- cost [1:100, ]
CostMonths <- contToDisc(dataShort=subCost, timeColumn = "time", intervalLimits = IntBorders)
head(CostMonths)

# Select subsample giving number of equidistant intervals
CostMonths <- contToDisc(dataShort = subCost, timeColumn = "time", intervalLimits = 10, equi = TRUE)
head(CostMonths)

}
\references{
\insertRef{tutzModelDisc}{discSurv}
}
\seealso{
\code{\link{dataLong}}, \code{\link{dataLongTimeDep}},
\code{\link{dataLongCompRisks}}
}
\author{
Thomas Welchowski \email{welchow@imbie.meb.uni-bonn.de}
}
\keyword{datagen}
