% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataSets.R
\docType{data}
\name{crash2}
\alias{crash2}
\title{Crash 2 competing risk data}
\source{
\link[Hmisc]{getHdata}
}
\usage{
data(crash2)
}
\description{
Adapted version of the crash2 trial data as availlable in the package Hmisc. Both death or survival and main cause of death are included. 
Death times are discretized into days. Included covariates are sex and age of patient, elapsed time between injury and 
hospitalization, type of injury, systolic blood pressure, heart rate, respiratory rate, central capillary 
refill time and total glascow coma score.
#' \itemize{
  \item Column "time" is time until death or hospital discharge/transfer in weeks.
}
\itemize{
\item Column "Status" denotes type of death\itemize{
  \item bleeding
  \item head injury
  \item vascular occlusion 
  \item multi organ failure
  \item other
  \item NA if patient is not dead (see "statusSE")
  }
}
\itemize{
  \item Column "statusSE" denotes death or discharge/transfer from hospital\itemize{
  \item 0 - Transfer/Discharge
  \item 1 - Death
  }
}
\itemize{
  \item Column "sex" denotes sex of the patient.
}
\itemize{
  \item Column "age" denotes age of the patient in years.
}
\itemize{
  \item Column "injurytime" gives time in hours between injury and hospitalization.
}
\itemize{
  \item Column "injurytype" denotes type of injury, one in \itemize{
  \item blunt
  \item penetrating
  \item blunt and penetrating
  }
}
\itemize{
  \item Column "sbp" denotes systolic blood pressure in mmHg.
}
\itemize{
  \item Column "rr" denotes respiratory rate per minute.
}
\itemize{
  \item Column "cc" denotes central capillary refill time in seconds.
}
\itemize{
  \item Column "hr" denotes heart rate per minute.
}
\itemize{
  \item Column "gcs" denotes total Glascow Coma Score.
}
}
\author{
David Koehler \email{koehler@imbie.uni-bonn.de}
}
\keyword{data}
