% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiscSurvEstimation.R
\name{estCumInz}
\alias{estCumInz}
\title{Estimates Cumulative Incidence Function for Discrete Time Competing Risks Models}
\usage{
estCumInz(hazards, eventFocus)
}
\arguments{
\item{hazards}{Estimated discrete hazard rates of all events ("numeric matrix"). 
Each column represents one event. The first column is assumed to contain the censoring case 
and the discrete hazards should only vary over time in each row.}

\item{eventFocus}{Column that represent the discrete hazards of the primary event ("integer vector").}
}
\value{
Returns cumulative incidence function of the primary event. 
If argument \emph{nonparCI} is set to TRUE, then a list is returned: 
The first element includes the cumulative incidence function. 
The second list element contains the lower and the third list element the upper bound of
the pointwise confidence intervals.
}
\description{
Estimates the cumulative incidence function of a discrete time competing risks model 
given covariates P(T <= t, event = k | x).
}
\details{
The covariates set is required to be constant across rows.
}
\examples{

# Example with unemployment data
library(Ecdat)
data(UnempDur)

# Select subsample
SubUnempDur <- UnempDur [1:100, ]

# Estimate GEE models for all events
estGEE <- compRisksGEE(datShort = SubUnempDur, dataTransform = "dataLongCompRisks", 
corstr = "independence", formulaVariable =~ timeInt + age + ui + logwage * ui, 
eventColumns = c("censor1", "censor2", "censor3", "censor4"), timeColumn = "spell")

# Estimate hazards of all events given the covariates of third person
SubUnempDurLong <- dataLongCompRisks(dataShort = SubUnempDur, 
eventColumns = c("censor1", "censor2", "censor3", "censor4"), timeColumn = "spell") 
preds <- predict(estGEE, subset(SubUnempDurLong, obj == 3))

# Estimate cumulative incidence function
cumInzGEE <- estCumInz(preds, eventFocus = 2)
cumInzGEE

}
\references{
\insertRef{minjungDiscComp}{discSurv}
}
\seealso{
\code{\link{compRisksGEE}}, \code{\link{dataLongCompRisks}}, 
\code{\link{dataLongCompRisksTimeDep}}, \code{\link[geepack]{geeglm}},
}
\author{
Thomas Welchowski \email{welchow@imbie.meb.uni-bonn.de}
}
\keyword{survival}
