% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiscSurvEstimationCR.R
\name{estSurvCompRisks}
\alias{estSurvCompRisks}
\title{Estimated Survival Function for Competing Risks}
\usage{
estSurvCompRisks(hazards)
}
\arguments{
\item{hazards}{Estimated discrete hazards ("numeric matrix"). 
Discrete hazards of each time interval are stored in the rows and the number of columns equal to the number of events.}
}
\value{
Estimated survival probabilities ("numeric vector")
}
\description{
Computes the survival function S(T>t|x) based on estimated hazards of a competing risks model.
The discrete hazards may or may not depend on covariates. The covariates have to
be equal across all estimated hazards. Therefore the given discrete hazards
should only vary over time.
}
\details{
The argument \emph{hazards} must be given for all intervals [a_0, a_1), [a_1,
a_2), ..., [a_{q-1}, a_q), [a_q, Inf).
}
\note{
It is assumed that all time points up to the last interval [a_q, Inf)
are available. If not already present, these can be added manually.
}
\examples{

# Example unemployment data
library(Ecdat)
data(UnempDur)

# Select subsample
subUnempDur <- UnempDur [1:100, ]

# Convert to long format
UnempLong <- dataLongCompRisks(dataShort = subUnempDur, timeColumn = "spell", 
eventColumns = c("censor1", "censor4"))
head(UnempLong)

# Estimate continuation ratio model with logit link
vglmFit <- VGAM::vglm(formula = cbind(e0, e1, e2) ~ timeInt + age + logwage, data = UnempLong,
family = VGAM::multinomial(refLevel = "e0"))

# Estimate discrete survival function given age, logwage of first person
hazards <- VGAM::predictvglm(vglmFit, newdata = subset(UnempLong, obj == 1), type = "response")[,-1]
SurvivalFuncCondX <- estSurvCompRisks(rbind(hazards, 0.5))
SurvivalFuncCondX


}
\references{
\insertRef{tutzModelDisc}{discSurv}
}
\seealso{
\code{\link{estSurv}}
}
\author{
Moritz Berger \email{moritz.berger@imbie.uni-bonn.de} \cr \url{https://www.imbie.uni-bonn.de/personen/dr-moritz-berger/}
}
\keyword{competing_risks}
\keyword{discrete_survival}
