% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiscSurvEvaluationCR.R
\name{intPredErrCompRisks}
\alias{intPredErrCompRisks}
\title{Integrated Prediction Error for Competing Risks}
\usage{
intPredErrCompRisks(
  testPreds,
  testDataShort,
  trainDataShort,
  timeColumn,
  eventColumns,
  tmax = NULL
)
}
\arguments{
\item{testPreds}{Predictions on the test data with model fitted on training data. Must be a matrix, 
with the predictions in the rows and the number of columns equal to the number of events.}

\item{testDataShort}{Test data in short format.}

\item{trainDataShort}{Train data in short format.}

\item{timeColumn}{Character giving the column name of the observed times.}

\item{eventColumns}{Character vector giving the column names of the event indicators (excluding censoring column).}

\item{tmax}{Gives the maximum time interval for which prediction errors are
calculated. It must not be higher than the maximum observed time in the
training data.}
}
\value{
Integrated prediction errors for each competing event. Matrix, with the integrated predictions in the rows 
and the number of columns equal to the number of events.
}
\description{
Estimates integrated prediction errors of arbitrary prediction models in the case of competing risks.
}
\examples{

###########################
# Example unemployment data
library(Ecdat)
data(UnempDur)

# Select subsample
selectInd1 <- 1:200
selectInd2 <- 201:400
trainSet <- UnempDur[which(UnempDur$spell \%in\% (1:10))[selectInd1], ]
testSet <- UnempDur[which(UnempDur$spell \%in\% (1:10))[selectInd2], ]

# Convert to long format 
trainSet_long <- dataLongCompRisks(dataShort=trainSet, timeColumn="spell", 
eventColumns=c("censor1", "censor4"), timeAsFactor=TRUE)
tmax          <- max(trainSet$spell)
testSet_long <- dataLongCompRisks(dataShort=testSet, timeColumn="spell", 
eventColumns=c("censor1", "censor4"), aggTimeFormat = TRUE, lastTheoInt=tmax,
timeAsFactor=TRUE)

# Estimate continuation ratio model with logit link
vglmFit <- VGAM::vglm(formula=cbind(e0, e1, e2) ~ timeInt + age + logwage, 
data=trainSet_long, family=VGAM::multinomial(refLevel="e0"))

# Calculate predicted hazards
predHazards <- VGAM::predictvglm(vglmFit, newdata=testSet_long, type="response")

# Compute integrated prediction error 
intPredErrCompRisks(testPreds=predHazards[,-1], testSet, trainSet, "spell", 
c("censor1", "censor4"), tmax)


}
\references{
\insertRef{heyardValCompRisks}{discSurv}
}
\seealso{
\code{\link{predErrCompRisks}}, \code{\link{predErrCurve}}
}
\author{
Moritz Berger \email{moritz.berger@imbie.uni-bonn.de} \cr \url{https://www.imbie.uni-bonn.de/personen/dr-moritz-berger/}
}
\keyword{competing_risks}
\keyword{discrete_survival}
