% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{dodgr_streetnet_geodesic}
\alias{dodgr_streetnet_geodesic}
\title{Force \link{weight_streetnet} to use geodesic distances.}
\usage{
dodgr_streetnet_geodesic(unset = FALSE)
}
\arguments{
\item{unset}{Calling this function with \code{unset = TRUE} reverts distance
calculations to those described above, rather than geodesic.}
}
\value{
Nothing; the function is called for its side-effect only of setting
distance calculations to geodesic.
}
\description{
Distances by default are Mapbox "cheap" distances if maximal network
distances are < 100km, otherwise Haversine distances. Calling this function
forces all calls to \link{weight_streetnet} from that point on to use
geodesic distances. These are more computationally expensive to calculate,
and weighting networks will likely take more time.
}
\examples{
net0 <- weight_streetnet (hampi) # Default "cheap" method
dodgr_streetnet_geodesic ()
net1 <- weight_streetnet (hampi)
cor (net0$d, net1$d) # Strongly correlated, but not perfect
max (abs (net0$d - net1$d)) # in metres
}
\seealso{
Other extraction: 
\code{\link{dodgr_streetnet}()},
\code{\link{dodgr_streetnet_sc}()},
\code{\link{weight_railway}()},
\code{\link{weight_streetnet}()}
}
\concept{extraction}
