% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topography.R
\name{angularity}
\alias{angularity}
\title{angularity}
\usage{
angularity(mesh, ratio = FALSE)
}
\arguments{
\item{mesh}{object of class mesh3d}

\item{ratio}{logical, if false standard angularity will be computed (default),
if true a relative angularity ratio will be computed (see below)}
}
\value{
If ratio = FALSE, a numeric vector of angularity values i.e. delta slope of
each polygon compared to their adjacent polygons, for all the polygons of the
mesh.
If ratio = TRUE, a numeric vector of angularity ratio values. Ratio is computed
by dividing polygon slope by 90, replacing vertex elevation by the average
ratio of faces adjacent to the vertex, then dividing the slope of polygons from
this new mesh by 90. Although it is a non-standard variable, it was implemented because
it better discriminates sharp edges than basic angularity.
Warning: both options can take up a significant amount of time for large meshes.
}
\description{
Compute the angularity (delta slope).
}
\examples{
delta_slope <- angularity(dkmodel$complex, ratio = FALSE)
summary(delta_slope)
#angularity ratio:
delta_slope_ratio <- angularity(dkmodel$complex, ratio = TRUE)
summary(delta_slope_ratio)

#render on a map:
dkmap(dkmodel$complex, delta_slope, col = "slope",
legend.lab = "Angularity (°)")
#angularity ratio:
dkmap(dkmodel$complex, delta_slope_ratio, col = "slope",
legend.lab = "Angularity ratio")

}
\references{
\href{https://palaeo-electronica.org/2000_1/gorilla/issue1_00.htm}{Ungar and Williamson (2000)}
}
