% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topography.R
\name{opcr}
\alias{opcr}
\title{orientation patch count rotated}
\usage{
opcr(mesh, bins = 8, min.size = 3)
}
\arguments{
\item{mesh}{object of class mesh3d}

\item{bins}{the number of orientation bins to be defined (default set to 8)}

\item{min.size}{the minimal amount of polygons defining a "patch" (default set to 3)}
}
\value{
A data.frame displaying the number of patches and their size (number of triangles)
for each orientation bin.
}
\description{
Compute the orientation patch count rotated of a triangle mesh.
}
\examples{
#8bins (default):
opcr <- opcr(dkmodel$complex)
#16 bins (computation time increase exponentially):
opcr <- opcr(dkmodel$complex, bins = 16)
}
\references{
\doi{10.1038/nature10880}{Wilson et al. (2012)}
}
\seealso{
\code{\link{opc}}

\code{\link{orient}}

\code{\link[molaR]{OPCr}}
}
