% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doremi.R
\name{calculate.gold}
\alias{calculate.gold}
\title{Calculation of derivatives using the GOLD method}
\usage{
calculate.gold(signal, time, embedding = 3, n = 2)
}
\arguments{
\item{signal}{is a vector containing the data from which the derivative is estimated.}

\item{time}{is a vector containing the time values corresponding to the signal. Arguments signal and time must have the same length.}

\item{embedding}{is an integer indicating the number of points to consider for derivative calculation. Embedding must be greater than 1 because at least
two points are needed for the calculation of the first derivative and at least 3 for the calculation of the second derivative.}

\item{n}{is the maximum order of derivative to estimate.}
}
\value{
Returns a list containing the following elements:

dtime- contains the time values in which the derivative was calculated. That is, the moving average of the input time over embedding points.

dsignal- is a data.frame containing n+1 columns and the same number of rows as the signal.
The column k is the k-1 order derivative of the signal over embedding points.

embedding- number of points used for the derivative calculation.

n - the maximum derivative order calculated n
}
\description{
\code{calculate.gold} estimates the derivatives of a variable using the Generalized Orthogonal Local Derivative (GOLD)
method described in \doi{10.1080/00273171.2010.498294}{Deboeck (2010)}. The code available on this paper was extracted and adapted for non constant time steps.
This method allows calculating over a number of measurement points (called the embedding number) derivatives with uncorrelated errors.
}
\examples{
#In the following example the derivatives for the function y(t) = t^2 are calculated.
#The expected results are:
#y'(t) = 2t and y''(t) = 2
time <- c(1:500)/100
signal <- time^2
result <- calculate.gold(signal = signal, time = time, embedding = 5)

}
\keyword{derivative}
\keyword{embedding-number}
