% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_sample_rep.R
\name{draw_sample_rep}
\alias{draw_sample_rep}
\title{Multiple Sample Selection}
\usage{
draw_sample_rep(
  dist,
  n,
  rep = 1,
  skew,
  kurts,
  replacement = TRUE,
  col_id = 1,
  col_total = numeric(),
  exact = FALSE
)
}
\arguments{
\item{dist}{data frame:consists of id and scores with no missing}

\item{n}{numeric: desired sample size}

\item{rep}{numeric: replication}

\item{skew}{numeric: the skewness value}

\item{kurts}{numeric: the kurtosis value}

\item{replacement}{logical:Sample with or without replacement? (default is FALSE).}

\item{col_id}{index of column ID's}

\item{col_total}{index of column total score}

\item{exact}{default is FALSE conduct draw_sample_n_ir function, it is faster and nearest version of draw_sample_ir function.}
}
\value{
This function returns a \code{list} including following:
\itemize{
\item a matrix: Descriptive statistics of the given data,
                the reference vector and the sample.
\item a data frame: The id's and scores of the sample
\item graph: Histograms for the “data” and the “sample”
}
}
\description{
Multiple Sample Selection
}
\examples{
# Example data provided with package
data(likert_example)
# First 6 rows of the example_data
head(likert_example)
# Draw three samples based on Score_1(from negatively skewed to normal)
# This example takes considerable computation time.
samples <- draw_sample_rep(dist=likert_example,n=200,rep=3,skew=0,
kurts=0,replacement =TRUE,  col_id = 1,
col_total = numeric(),
exact = FALSE)
# to get first sample
samples$sample[[1]]
# to get second sample
samples$sample[[2]]
\dontrun{
# to export 10 samples
for(i in 1:3){
 write.csv(samples$sample[[i]],row.names = FALSE,paste("sample_",i,".csv",sep=""))
 }
}
}
