% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dice.R
\docType{class}
\name{Dice}
\alias{Dice}
\alias{show,Dice-method}
\alias{Ops,Dice,numeric-method}
\alias{Ops,numeric,Dice-method}
\alias{Ops,Dice,Dice-method}
\alias{*,numeric,Dice-method}
\alias{Math,Dice-method}
\alias{Math2,Dice-method}
\alias{Summary,Dice-method}
\title{An S4 class to represent dice}
\usage{
\S4method{show}{Dice}(object)

\S4method{Ops}{Dice,numeric}(e1, e2)

\S4method{Ops}{numeric,Dice}(e1, e2)

\S4method{Ops}{Dice,Dice}(e1, e2)

\S4method{*}{numeric,Dice}(e1, e2)

\S4method{Math}{Dice}(x)

\S4method{Math2}{Dice}(x, digits)

\S4method{Summary}{Dice}(x, ..., na.rm = FALSE)
}
\arguments{
\item{object}{A Dice object.}

\item{e1}{A numeric scalar or a Dice object.}

\item{e2}{A numeric scalar or a Dice object.}

\item{x}{A Dice object}

\item{digits}{Number of digits to be used in \code{\link[=round]{round()}} or \code{\link[=signif]{signif()}}.}

\item{...}{Numeric arguments.}

\item{na.rm}{A logical indicating whether missing values should be removed.}
}
\description{
A virtual representation of a die that supports the same arithmetic
operations as a numeric scalar, with the special property that, when
operated on, its value is randomly sampled from the die's faces. See below
for more details.
}
\details{
This S4 class extends \link{numeric} with the goal of creating an interactive die
inside of R. In short, an instance of this class functions as a numeric
scalar for most intents and purposes except that, when its value is needed,
it returns one of its faces at random.

For more information on exactly what operations are supported, see the
\strong{Operations} section below. To learn more about how to create an object of
this class, see the dice creating function \code{\link[=d]{d()}}. For roll distributions,
see the \link{roll} family. For plotting those distributions, see the \link{roll-plot}
family.
}
\section{Slots}{

\describe{
\item{\code{faces}}{A numeric vector with the die's faces.}
}}

\section{Operations}{

By default, when printed, an object of this class returns a numeric vector
with all of its faces. In order to actually "roll" the die (that is, get one
of its faces at random), one can simply operate on it. Any arithmetic
expression should trigger a die into sampling its faces, even \code{dX + 0} and
\code{1 * dX}.

All standard arithmetic operations are supported, along with comparisons,
logic assertions, mathematical functions, and summaries: every group
described in \link{S4groupGeneric} except for \code{Complex}. Note that, when used in
other situations, like \code{\link[=c]{c()}}, the die will return all of its faces.

These functions also work in the exact same way as they would with regular
numeric scalars, with the exception of multiplication. With the goal of
supporting the very common operation \code{NdX} ("rolling \code{N} dice with \code{X} faces
and adding the results"), the multiplication symbol behaves differently
depending on the context: \code{N * dX} will work as \code{NdX} and \code{dX * N} will work
as \verb{N x dX} ("rolling a die with \code{X} faces and multiplying the result by
\code{N}").

The \link{roll} and \link{roll-plot} families of functions make ample use of roll
expressions like the ones described here. They even support some built-in
dice that can be used without being created with \code{\link[=d]{d()}}.
}

\examples{
set.seed(42)

# Create some dice with d()
d6 <- d(6)
d20 <- d(20)

# Print faces from die
d6

# Roll 1d6
1 * d6

# Check if an attack hits and deal damage
if (d20 + 8 >= 12) {
  print(4 * d6)
} else {
  print(0)
}
}
\seealso{
\code{\link[=d]{d()}}, \link{roll}, \link{roll-plot}.
}
