% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/informat.R
\name{informat}
\alias{informat}
\title{A function to check whether a given data table/matrix/data frame is in the appropriate for drpop.}
\usage{
informat(data, K = 2)
}
\arguments{
\item{data}{The data table/matrix/data frame which is to be checked.}

\item{K}{The number of lists (optional).}
}
\value{
A boolean for whether \code{data} is in the appropriate format.
}
\description{
A function to check whether a given data table/matrix/data frame is in the appropriate for drpop.
}
\examples{
data = matrix(sample(c(0,1), 2000, replace = TRUE), ncol = 2)
x = matrix(rnorm(nrow(data)*3, 2,1), nrow = nrow(data))

informat(data = data)
#this returns TRUE

data = cbind(data, x)
informat(data = data)
#this returns TRUE

informat(data = data, K = 3)
#this returns FALSE
}
