% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popsize_cond.R
\name{popsize_cond}
\alias{popsize_cond}
\title{Estimate total population size and capture probability using user provided set of models conditioned on an attribute.}
\usage{
popsize_cond(
  data,
  K = 2,
  filterrows = FALSE,
  funcname = c("rangerlogit"),
  condvar,
  nfolds = 2,
  margin = 0.005,
  sl.lib = c("SL.gam", "SL.glm", "SL.glm.interaction", "SL.ranger", "SL.glmnet"),
  TMLE = TRUE,
  PLUGIN = TRUE,
  Nmin = 100,
  ...
)
}
\arguments{
\item{data}{The data frame in capture-recapture format for which total population is to be estimated.
The first K columns are the capture history indicators for the K lists. The remaining columns are covariates in numeric format.}

\item{K}{The number of lists in the data. typically the first \code{K} rows of data.}

\item{filterrows}{A logical value denoting whether to remove all rows with only zeroes.}

\item{funcname}{The vector of estimation function names to obtain the population size.}

\item{condvar}{The covariate for which conditional estimates are required.}

\item{nfolds}{The number of folds to be used for cross fitting.}

\item{margin}{The minimum value the estimates can attain to bound them away from zero.}

\item{sl.lib}{Algorithm library for \code{\link[=qhat_sl]{qhat_sl()}}. See \code{\link[SuperLearner:listWrappers]{SuperLearner::listWrappers()}}. Default library includes "gam", "glm", "glmnet", "glm.interaction", "ranger".}

\item{TMLE}{The logical value to indicate whether TMLE has to be computed.}

\item{PLUGIN}{The logical value to indicate whether the plug-in estimates are returned.}

\item{Nmin}{The cutoff for minimum sample size to perform doubly robust estimation. Otherwise, Petersen estimator is returned.}

\item{...}{Any extra arguments passed into the function. See \code{\link[=qhat_rangerlogit]{qhat_rangerlogit()}}, \code{\link[=qhat_sl]{qhat_sl()}}, \code{\link[=tmle]{tmle()}}.}
}
\value{
A list of estimates containing the following components for each list-pair, model and method (PI = plug-in, DR = doubly-robust, TMLE = targeted maximum likelihood estimate):
\item{result}{  A dataframe of the below estimated quantities.
\itemize{
\item{psi}{  The estimated capture probability.}
\item{sigma}{  The efficiency bound.}
\item{n}{  The estimated population size n.}
\item{sigman}{  The estimated standard deviation of the population size.}
\item{cin.l}{  The estimated lower bound of a 95\% confidence interval of \code{n}.}
\item{cin.u}{  The estimated upper bound of a 95\% confidence interval of \code{n}.}}}
\item{N}{  The number of data points used in the estimation after removing rows with missing data.}
\item{ifvals}{  The estimated influence function values for the observed data.}
\item{nuis}{  The estimated nuisance functions (q12, q1, q2) for each element in funcname.}
\item{nuistmle}{  The estimated nuisance functions (q12, q1, q2) from tmle for each element in funcname.}
\item{idfold}{  The division of the rows into sets (folds) for cross-fitting.}
}
\description{
Estimate total population size and capture probability using user provided set of models conditioned on an attribute.
}
\examples{
\donttest{
data = simuldata(n = 10000, l = 2, categorical = TRUE)$data

psin_estimate = popsize_cond(data = data, funcname = c("logit", "gam"),
     condvar = 'catcov', PLUGIN = TRUE, TMLE = TRUE)
#this returns the plug-in, the bias-corrected and the tmle estimate for the
#two models conditioned on column catcov
}
}
\references{
Das, M., Kennedy, E. H., & Jewell, N.P. (2021). Doubly robust capture-recapture methods for estimating population size. \emph{arXiv preprint} \emph{arXiv:2104.14091}.
}
\seealso{
\code{\link{popsize}}
}
