% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsample.R
\name{dsample}
\alias{dsample}
\title{Generating Random Samples via Wang-Lee algorithm}
\usage{
dsample(expr, rpmat, n = 1000, nk = 10000, wconst)
}
\arguments{
\item{expr}{expression of a target density function}

\item{rpmat}{matrix containing random points for discretization}

\item{n}{non-negative integer, the desired sample size.}

\item{nk}{positive integer, the number of contours.  See \sQuote{Details}.}

\item{wconst}{real number between 0 and 1.  See \sQuote{Details}.}
}
\value{
\code{dsample} gives the samples in \code{data.frame} with number of rows \code{n} and number of columns \code{ncol(rpmat)}.
}
\description{
\code{dsample} generates a sample of specified size \code{n} from the target density function (up to a normalizing constant) based on the Wang-Lee algorithm.
}
\details{
\code{X} has the number of rows equals to the number of discrete base points. In each row, the first element contains the functional value of the target density and the rest elements are the coordinates at which the density is evaluated.
\code{wconst} is a constant for adjusting the volume of the last contour.
}
\examples{
## Example on page 414 in West (1993)
expr <- expression((x1*(1-x2))^5 * (x2*(1-x1))^3 * (1-x1*(1-x2)-x2*(1-x1))^37)
sets <- list(x1=runif(1e3), x2=runif(1e3))
smp <- dsample(expr=expr, rpmat=sets, nk=1e2, n=1e3)
}
\references{
Wang, L. and Lee, C.H. (2014). Discretization-based direct random sample generation. Computational Statistics and Data Analysis, 71, 1001-1010.
Lee, C.H. (2009). Efficient Monte Carlo Random Sample Generation through Discretization, MSc thesis, Department of Satistics, University of Manitoba, Canada
}
\keyword{discretization}
\keyword{sampling}
