% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{build_Q}
\alias{build_Q}
\title{Compute the quadratic term in Bayesian trend filtering}
\usage{
build_Q(obs_sigma_t2, evol_sigma_t2, D = 1)
}
\arguments{
\item{obs_sigma_t2}{the \code{T x 1} vector of observation error variances}

\item{evol_sigma_t2}{the \code{T x 1} vector of evolution error variances}

\item{D}{the degree of differencing (one or two)}
}
\value{
Banded \code{T x T} Matrix (object) \code{Q}
}
\description{
Compute the quadratic term arising in the full conditional distribution
of a Bayesian trend filtering model with \code{D = 1} or \code{D = 2}.
This function exploits the known \code{D}-banded structure of \code{Q}
to compute the matrix directly, using objects in the Matrix package.
}
