% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{initEvol0}
\alias{initEvol0}
\title{Initialize the parameters for the initial state variance}
\usage{
initEvol0(mu0, commonSD = TRUE)
}
\arguments{
\item{mu0}{\code{p x 1} vector of initial values (undifferenced)}

\item{commonSD}{logical; if TRUE, use common SDs (otherwise distinct)}
}
\value{
List of relevant components:
the \code{p x 1} evolution error SD \code{sigma_w0},
the \code{p x 1} parameter-expanded RV's \code{px_sigma_w0},
and the corresponding global scale parameters
\code{sigma_00} and \code{px_sigma_00} (ignore if commonSD)
}
\description{
The initial state SDs are assumed to follow half-Cauchy priors, C+(0,A),
where the SDs may be common or distinct among the states.
}
\details{
This function initializes the parameters for a PX-Gibbs sampler.
}
