#' @title Curricula and Social classes
#'
#' @description Hollingshead (1949) found that the members of a small Middle
#' Western community in the United States divided themselves into 5 social
#' classes. He investigated his prediction that adolescents in the different
#' social classes would enroll in different curricula
#'
#' @format A data set of 390 subjects on 5 social classes and 3 different
#' curricula:
#' \describe{
#'  \item{\code{s.class1}}{Merged social classes I and II because the
#'  frequencies were small}
#'  \item{\code{s.class2}}{Social class III}
#'  \item{\code{s.class3}}{Social class IV}
#'  \item{\code{s.class4}}{Social class V}
#'  \item{\code{curricula1}}{College Prep curriculum}
#'  \item{\code{curricula2}}{General curriculum}
#'  \item{\code{curricula3}}{Commercial curriculum}
#'  }
#'
#' @details The data were originally collected from 390 participants in terms
#' of their social classes and actual curriculum enrollments.
#'
#' @source Nishisato, S. and Nishisato, I.(1994). \emph{Dual Scaling in a
#' Nutshell}. Toronto: MicroStats.
#'
#' @references Hollingshead, A.B. (1949). Elmtown's Youth: The Impact of
#' Social Classes on Adolescents. \emph{Wiley}.
#'
#' @usage curricula
#'
#' @keywords datasets
"curricula"
