% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds_mc.R
\name{ds_mc}
\alias{ds_mc}
\title{Multiple choice data analysis}
\usage{
ds_mc(input, solutions = NULL, mode = c("rad", "act"))
}
\arguments{
\item{input}{A data set with valid data}

\item{solutions}{Optional argument. A number of intended solutions}

\item{mode}{Optional argument. In case of NA values, the action to be taken.
See help("ds_mc_check") for more information. Radical action by default.}
}
\value{
\item{call}{Call with all of the specified arguments are specified by
their full names}
\item{orig_data}{Initial data}
\item{item_op_lbl}{Item options labels}
\item{sub_lbl}{Subjects options labels}
\item{solutions}{Maximum possible solutions}
\item{out}{Results obtained}
\item{item_stat}{Item statistics}
\item{info}{Distribution of component}
\item{rij}{Inter item correlation}
\item{proj_opt}{Projected option weights}
\item{proj_sub}{Projected subject scores}
\item{norm_opt}{Normed option weights}
\item{norm_sub}{Normed subject scores}
}
\description{
Multiple choice data analysis
}
\examples{
ds_mc(singaporean)
ds_mc(singaporean, solutions = 2)
}
\seealso{
\code{\link[=ds_mc_check]{ds_mc_check()}}
}
