% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds_mcf.R
\name{ds_mcf}
\alias{ds_mcf}
\title{Forced multiple choice data analysis}
\usage{
ds_mcf(input, crit, solutions = NULL, mode = c("rad", "act"))
}
\arguments{
\item{input}{A data set with valid data}

\item{crit}{Used to determine a criterion item for forced
classification analysis}

\item{solutions}{Optional argument. A number of intended solutions}

\item{mode}{Correction mode to incorrect data.}
}
\value{
\item{call}{Call with all of the specified arguments are specified by
their full names}
\item{orig_data}{Initial data}
\item{crit_item}{The criterion item for forced classification}
\item{item_op_lbl}{Item options labels}
\item{sub_lbl}{Subjects options labels}
\item{solutions_mcf}{Maximum possible solutions for forced multiple choice}
\item{solutions_mc}{Maximum possible solutions for multiple choice}
\item{info_\emph{x}}{Distribution of component information according to
output}
\item{out_\emph{x}}{Results obtained according to output}
\item{item_stat_\emph{x}}{Item statistics according to output (Not type C)}
\item{rij_\emph{x}}{Inter item correlation according to output (Not type C)}
\item{proj_opt_\emph{x}}{Projected option weights according to output}
\item{proj_sub_\emph{x}}{Projected subject scores according to output}
\item{norm_opt_\emph{x}}{Normed option weights according to output}
\item{norm_sub_\emph{x}}{Normed subject scores according to output}
\item{match_missmatch}{Match-mismatch tables}
\item{predict}{Percentage of correct classification}
\item{comp_cont}{Component contamination}
\item{tot_cont}{Total contamination}
}
\description{
Forced multiple choice data analysis
}
\details{
There are three types of outputs: Forced classification of the
criterion item (type A); dual scaling of non-criterion items by ignoring
the criterion item (type B); dual scaling of non-criterion items after
eliminating the influence of the criterion item (type C).  These three
types correspond to, respectively, dual scaling of data projected onto the
subspace of the criterion item, dual scaling of non-criterion items, and
dual scaling of data in the complementary space of the criterion item.
}
\examples{
ds_mcf(singaporean, crit = 1)
}
\seealso{
\code{\link[=ds_mc_check]{ds_mc_check()}}
}
