% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_qgroups.R
\name{create_qgroups}
\alias{create_qgroups}
\title{Create Quantile Groups}
\usage{
create_qgroups(x, groups = 4, probs = seq(1/groups, 1 - 1/groups,
  1/groups), strata = NULL, quantile_list = list(na.rm = TRUE),
  cut_list = list(include.lowest = TRUE))
}
\arguments{
\item{x}{Numeric vector.}

\item{groups}{Numeric value, e.g. 3 for tertiles, 4 for quartiles, etc.}

\item{probs}{Numeric vector.}

\item{strata}{Factor specifying subgroups to calculate quantiles within. For 
multivariable subgroups, you can use \code{\link{interaction}}.}

\item{quantile_list}{Arguments to pass to \code{\link[stats]{quantile}}.}

\item{cut_list}{Arguments to pass to \code{\link{cut}}.}
}
\value{
Factor variable.
}
\description{
Combines \code{\link[stats]{quantile}} and \code{\link[base]{cut}} into a 
single function, with strata-specific quantiles possible. For example, you 
could create sex-specific height tertiles with 
\code{create_qgroups(height, groups = 3, strata = sex)}. Compatible with 
\strong{dplyr} functions like \code{\link[dplyr]{mutate}} and 
\code{\link[dplyr:mutate]{transmute}}.
}
\examples{
# In mtcars dataset, create tertiles for mpg
mtcars$mpg_tertiles <- create_qgroups(mtcars$mpg, groups = 3)
table(mtcars$mpg_tertiles)

# Define tertile cutpoints separately for 4-, 6-, and 8-cylinder vehicles
mtcars$mpg_tertiles <- create_qgroups(mtcars$mpg, groups = 3, strata = mtcars$cyl)
table(mtcars$mpg_tertiles)

# Works with dplyr functions like mutate
mtcars <- mtcars \%>\% 
  dplyr::mutate(mpg_tertiles = create_qgroups(mpg, groups = 3, strata = cyl))
table(mtcars$mpg_tertiles)

# Can embed in lm, glm, etc.
summary(lm(mpg ~ create_qgroups(wt), data = mtcars))

}
