% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_qgroups_svy.R
\name{create_qgroups_svy}
\alias{create_qgroups_svy}
\title{Create Quantile Groups (Complex Survey Data)}
\usage{
create_qgroups_svy(x, groups = 4, probs = seq(1/groups, 1 - 1/groups,
  1/groups), strata = NULL, design, svyquantile_list = list(na.rm =
  TRUE), cut_list = list(include.lowest = TRUE))
}
\arguments{
\item{x}{Numeric vector.}

\item{groups}{Numeric value, e.g. 3 for tertiles, 4 for quartiles, etc.}

\item{probs}{Numeric vector.}

\item{strata}{Factor specifying subgroups to calculate quantiles within. For 
multivariable subgroups, you can use \code{\link{interaction}}.}

\item{design}{Survey design object.}

\item{svyquantile_list}{Arguments to pass to 
\code{\link[survey]{svyquantile}}.}

\item{cut_list}{Arguments to pass to \code{\link{cut}}.}
}
\value{
Factor variable.
}
\description{
Complex survey version of \code{\link{create_qgroups}}. Relies heavily on the 
\strong{survey} package [1,2].
}
\references{
1. Therneau, T. (2015). A Package for Survival Analysis in S. R package
version 2.38. \url{https://cran.r-project.org/package=survival}.

2. Therneau, T.M. and Grambsch, P.M. (2000). Modeling Survival Data:
Extending the Cox Model. Springer, New York. ISBN 0-387-98784-3.
}
