% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iterate.R
\name{iterate}
\alias{iterate}
\title{Iterate Function Over All Combinations of User-Specified Inputs, Potentially 
Multiple Times}
\usage{
iterate(f, ..., all_combinations = TRUE, fix = NULL, trials = 1,
  varnames = NULL)
}
\arguments{
\item{f}{A function.}

\item{...}{Arguments to \code{f}, any of which can be vector-valued.}

\item{all_combinations}{Logical value for whether to iterate over all 
combinations of arguments in \code{...}, or just use the first set of 
elements, then the second, and so on.}

\item{fix}{List of arguments to \code{f} to hold fixed rather than loop over.}

\item{trials}{Numeric value.}

\item{varnames}{Character vector of names for values that \code{f} returns, 
to avoid generic labels (V1, V2, ...).}
}
\value{
Data frame.
}
\description{
Same idea as \strong{purrr}::\emph{pmap}, but with some different 
functionality. It can runs all combinations of vector-valued arguments in 
\code{...} or the 1st set, 2nd set, and so forth, and multiple trials can be 
run for each scenario, which can be useful for simulations.
}
\examples{
# Define function to generate data from N(mu, sigsq) and perform t-test.
f <- function(n = 100, mu = 0, sigsq = 1, alpha = 0.05) {
  x <- rnorm(n = n, mean = mu, sd = sqrt(sigsq))
  fit <- t.test(x = x, alpha = alpha)
  return(list(t = fit$statistic, p = fit$p.value))
}

# Call f once for various sample sizes and means
f \%>\% iterate(n = c(100, 500), mu = c(0.1, 0.25))

# Run 100 trials for each scenario and calculate empirical power
f \%>\% iterate(n = c(100, 500), mu = c(0.1, 0.25), trials = 100) \%>\%
  group_by(n, mu) \%>\%
  summarise(mean(p < 0.05))

}
