% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{gulf_of_alaska}
\alias{gulf_of_alaska}
\title{eastern Gulf of Alaska data}
\usage{
data(gulf_of_alaska)
}
\description{
Data used to demonstrate size-structured modelling including bottom-up
linkages.
\code{data(gulf_of_alaska)} loads a list that includes four components:
\itemize{
\item \code{years} the set of years modeled
\item \code{taxa} the set of taxa (including each stanza for age-structured populations)
\item \code{type} is a character vector indicating for each taxon (as vector names)
whether it is a heterotroph, autotroph, or detritus pool
\item \code{biomass_data} is a long-form data-frame with three columns, providing the Year,
Mass (in relative units for copepods and euphausiids, and million metric
tons for Pollock and sablefish), and Taxon for each year with available data
\item \code{catch_data} is a long-form data-frame with three columns, providing the Year,
Mass (in million metric tons), and Taxon for each year with available data
\item \code{P_over_B} is a numeric vector with the unitless ratio of biomass production to
population biomass for each taxon (as vector names)
\item \code{Q_over_B} is a numeric vector with the unitless ratio of biomass consumption to
population biomass for each taxon (as vector names)
\item \code{EE} is a numeric vector with the ecotrophic efficiency for each \code{taxa}, in
this case provided only for the detritus pool and determining its turn-over rate
\item \code{Diet_proportions} is a numeric matrix where each column lists the
proportion of biomass consumed for each predator (column)
that is provided by each prey (row)
\item \code{agecomp_data} is a named list with age-composition samples for any
age-structured population (named list element), where each list element
is a matrix with named rows indicating years, and columns indicating integer
ages
\item \code{stanza_groups} is a character vector with names matching taxa, and elements
indicating multi-stanza groups (i.e., age-structured populations)
\item \code{Amax} is a numeric vector indicating the maximum age (in years) for each
stanza as indicated in \code{names(stanza_groups)}.
\item \code{Leading} is a Boolean vector indicating which stanza is used for estimating
biomass (and therefore recruitment) for each \code{names(stanza_groups)}.
\item \code{K} is a numeric vector with the generalized von Bertalanffy growth coefficient
(in weight not length) for each \code{unique(stanza_groups)}
\item \code{d} is a numeric vector with the generalized von Bertalanffy growth coefficient
(in weight not length) for each \code{unique(stanza_groups)}
\item \code{Amat} is a numeric vector with the age at 50\% maturity (in years)
for each \code{unique(stanza_groups)}. If provided, it is used to back-calculate
and replace the value for \code{Wmat}
\item \code{Wmat} is a numeric vector with the weight at 50\% maturity (relative to W_inf)
for each \code{unique(stanza_groups)}.
\item \code{Wmatslope} is a numeric vector with the slope of the logistic maturity at weight
(relative to W_inf) for each \code{unique(stanza_groups)}
}
}
\details{
The data compiled come from a variety of sources:
\itemize{
\item Sablefish biomass index and age-comps are from a cooperative longline survey, and
the index is treated as a relative index.
\item Pollock biomass index and age-comps are from a bottom trawl survey, and
the index is treated as a relative index with a prior on the catchability coefficient.
\item Copepod biomass is from an oblique tow bongo net survey,
with data provided by Dave Kimmel.
\item Euphausiid biomass is from the Seward Long-Term Ecological Research program,
provided by Russ Hopcroft to the Ecological Status Report.
\item Other P_over_B, Q_over_B and Diet_proportions values
are derived from Rpath models, provided by Bia Dias.
\item Age-structed inputs are determined based on life-history information and
biological samples.
See Thorson et al. (In review) for more details regarding data standardization
and sources
}
}
\keyword{data}
