
<!-- README.md is generated from README.Rmd. Please edit that file -->

## eemR

<!-- badges: start -->

[![Package-License](https://img.shields.io/badge/license-GPL%20%28%3E=%202%29-brightgreen.svg?style=flat)](http://www.gnu.org/licenses/gpl-2.0.html)
[![CRAN_Status_Badge](http://www.r-pkg.org/badges/version/eemR)](https://cran.r-project.org/package=eemR)
[![Downloads](http://cranlogs.r-pkg.org/badges/eemR?color=brightgreen)](https://www.r-pkg.org:443/pkg/eemR)
[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.3257526.svg)](https://doi.org/10.5281/zenodo.3257526)
[![Codecov test
coverage](https://codecov.io/gh/PMassicotte/eemR/branch/main/graph/badge.svg)](https://app.codecov.io/gh/PMassicotte/eemR?branch=main)
[![R build
status](https://github.com/PMassicotte/eemR/workflows/R-CMD-check/badge.svg)](https://github.com/PMassicotte/eemR/actions)

<!-- badges: end -->

The **eemR** package implements various functions used calculate metrics
from excitation-emission matrix (EEM) as well as to preform
pre-processing corrections before PARAFAC analysis.

The latest release of the package from CRAN can be installed with:

``` r
install.packages("eemR")
```

The latest development version of the package can be installed with:

``` r
devtools::install_github("PMassicotte/eemR")
```

## Vignette

A detailed vignette presenting the package which can be viewed using:

``` r
vignette(topic = "introduction", package = "eemR")
```

## Supported spectrophotometers

At the moment, EEMs generated by the following spectrofluorometer are
officially supported.

- Cary Eclipse `.csv` files

- Aqualog `.dat` files

- Shimadzu `.TXT` files

- Fluoromax-4 `.dat` files

- Hitachi F-7000 FL `.TXT` files

EEM can be read using the `eem_read()` function. Please fill an
[issue](https://github.com/PMassicotte/eemR/issues) if you have other
file formats you would like to add to the package. You can also write
your own [import
function](http://pmassicotte.github.io/eemR/articles/custom-import-function.html)!
