% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/customizable_functions.R
\name{sim_exposure}
\alias{sim_exposure}
\title{Simulate time series of exposure values}
\usage{
sim_exposure(n, central = NULL, sd = NULL, trend = "no trend",
  slope = 1, amp = 0.6, exposure_type = NULL, start.date = "2001-01-01",
  cust_exp_func = NULL, cust_exp_args = NULL, cust_expdraw = NULL,
  cust_expdraw_args = list())
}
\arguments{
\item{n}{A non-negative integer specifying the number of days to simulate.}

\item{central}{A numeric value specifying the mean probability of exposure
(for binary data) or the mean exposure value (for continuous data).}

\item{sd}{A numeric value giving the standard deviation of the exposure
values from the exposure trend line.}

\item{trend}{A character string that specifies the desired trend function.
Options are:
\itemize{
  \item{"no trend": No trend, either seasonal or long-term (default).}
  \item{"cos1": A seasonal trend only.}
  \item{"cos2": A seasonal trend with variable amplitude across years.}
  \item{"cos3": A seasonal trend with steadily decreasing amplitude over time.}
  \item{"linear": A linear long-term trend with no seasonal trend.}
  \item{"curvilinear": A curved long-term trend with no seasonal trend.}
  \item{"cos1linear": A seasonal trend plus a linear long-term trend.}
  }
See the package vignette for examples of the shapes of these trends.}

\item{slope}{A numeric value specifying the slope of the trend, to be used
with \code{trend = "linear"} or \code{trend = "cos1linear"}.}

\item{amp}{A numeric value specifying the amplitude of the seasonal trend.
Must be between -1 and 1.}

\item{exposure_type}{A character string specifying the type of exposure.
Choices are "binary" or "continuous".}

\item{start.date}{A date of the format "yyyy-mm-dd" from which to begin
simulating daily exposures}

\item{cust_exp_func}{An R object specifying the function to use to generate custom
exposure values.}

\item{cust_exp_args}{A list of arguments used in the user-specified custom
function.}

\item{cust_expdraw}{An R object specifying a user-created function
which determines the distribution of random noise off of the trend line.
This function must have inputs \code{n} and \code{prob} for a binary exposure
function and inputs \code{n} and \code{mean} for a continuous exposure function.
The custom function must output a vector of simulated exposure values.}

\item{cust_expdraw_args}{A list of arguments other than \code{n} required by the
\code{cust_expdraw} function.}
}
\value{
A data frame with two columns: date (\code{date}) and simulated
   exposure values (\code{x}).
}
\description{
Simulates a time series of binary or continuous exposure values with or
without seasonal trends. It also allows the user to use a custom function for
the shape of the exposure trend.
}
\examples{
sim_exposure(n = 5, central = 0.25, exposure_type = "binary")
sim_exposure(n = 5, central = 100, sd = 10, exposure_type = "continuous")
library(ggplot2)
x_cont <- sim_exposure(n = 1000, central = 100, sd = 10,
                       exposure_type = "continuous",
                       trend = "cos1linear", amp = 0.6)
ggplot(x_cont, aes(x = date, y = x)) + geom_point()
x_cust <- sim_exposure(n = 1000, cust_exp_func = "custom_exposure",
                       cust_exp_args = list(metric = "temp"))
ggplot(x_cust, aes(x = date, y = x)) + geom_point()
}
