% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ega.R
\name{getParkesZones}
\alias{getParkesZones}
\title{Assign Parkes (Consensus) error grid zones to paired glucose values}
\usage{
getParkesZones(referenceVals, testVals, type = 1, unit = "gram")
}
\arguments{
\item{referenceVals}{A vector of glucose values obtained via the reference
method.}

\item{testVals}{A vector of glucose values obtained via a non-reference
method (e.g. a new meter). The values in this vector are paired with those
in \code{referenceVals}, so the length should be the same.}

\item{type}{An integer (1 or 2) specifying whether to obtain zones for Type 1
or Type 2 diabetes. Defaults to 1.}

\item{unit}{A string specifying the units of measurement. This should be either
\code{"gram"} (the default) for \code{mg/dl} or \code{"mol"} for \code{mmol/l}.}
}
\value{
A character vector is returned, with each element being one of
\code{"A"}, \code{"B"}, \code{"C"}, \code{"D"}, or \code{"E"}.
}
\description{
\code{referenceVals} and \code{testVals} are assumed to contain
paired glucose values from a reference method and a test method,
respectively. The discrepancy between the two values, as well as the
type of error grid desired (Type 1 or Type 2 diabetes), is used to place the
pair into a Parkes (Consensus) error grid zone, according to the
criteria described in the second reference below. \code{unit} contains info
on the unit of measurement. Two options exist: \code{"gram"} for mg/dL and
\code{"mol"} for mmol/l with \code{"gram"} applied by default.
}
\examples{
zones <- getParkesZones(glucose_data$ref, glucose_data$test)

# counts
table(zones)

# percentages
round (table (zones) / length (zones) * 100, digits=2)
}
\references{
Parkes, J. L., S. L. Slatin, S. Pardo, and B.H. Ginsberg. "A New Consensus
Error Grid to Evaluate the Clinical Significance of Inaccuracies in the
Measurement of Blood Glucose." Diabetes Care 23, no. 8 (August 2000):
1143-48

Pfutzner, Andreas, David C. Klonoff, Scott Pardo, and Joan L. Parkes.
"Technical Aspects of the Parkes Error Grid." Journal of Diabetes Science
and Technology 7, no. 5 (September 2013): 1275-81
}

