% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epe4md_calcula.R
\encoding{UTF-8}
\name{epe4md_calcula}
\alias{epe4md_calcula}
\title{Roda o modelo 4MD}
\usage{
epe4md_calcula(
  premissas_reg,
  ano_base,
  sequencial = FALSE,
  filtro_de_uf = "N",
  filtro_nome4md = "N",
  filtro_de_segmento = "N",
  filtro_de_custo_unitario_max = NULL,
  ano_max_resultado = 2050,
  altera_sistemas_existentes = FALSE,
  ano_decisao_alteracao = 2023,
  inflacao = 0.0375,
  taxa_desconto_nominal = 0.13,
  custo_reforco_rede = 200,
  ano_troca_inversor = 11,
  pagamento_disponibilidade = 0.3,
  disponibilidade_kwh_mes = 100,
  filtro_renda_domicilio = "maior_3sm",
  desconto_capex_local = 0,
  anos_desconto = 0,
  tx_cresc_grupo_a = 0.016,
  spb = 0.3,
  p_max = 0.01,
  q_max = 1,
  filtro_comercial = NA_real_,
  ajuste_ano_corrente = FALSE,
  ultimo_mes_ajuste = NA_integer_,
  metodo_ajuste = NA_character_,
  dir_dados_premissas = NA_character_
)
}
\arguments{
\item{premissas_reg}{data.frame. Input de premissas regulatórias para serem
consideradas nos cálculos. O dataframe deve ter as seguintes colunas
\itemize{
\item ano, numérico
\item alternativa, numérico. Uma das seguintes opções:
\itemize{
\item 0: Consumidor compensa todas as componentes tarifárias;
\item 1: Paga TUSD Distribuição;
\item 2: Anterior + TUSD Transmissão.
\item 3: Anterior + TUSD Encargos.
\item 4: Anterior + TUSD Perdas.
\item 5: Anterior + TE Encargos. Ou seja, compensa somente a TE Energia.
}
\item p_transicao, numérico. Parcela do custo da alternativa escolhida no parâmetro alternativa
a ser pago pelo consumidor
\item binomia e, binário. Define se há cobrança de uma
tarifa binômia na baixa tensão, em que as
componentes TUSD Distribuição e TUSD Transmissão passariam a ser cobradas de forma fixa, não sendo passíveis de compensação
\item demanda_g, binário. Define se há cobrança de TUSDg para a demanda de consumidores do
grupo A. Caso seja \code{FALSE}, é considerada a cobrança da TUSD consumo.
}

Um arquivo excel
instalado com este pacote, acessível via
\code{system.file("dados_premissas/2021/premissas_reg.xlsx", package = "epe4md")},
contém um exemplo de premissas de entrada.}

\item{ano_base}{numeric. Ano base da projeção. Define o ano em que a função
irá buscar a base de dados. Último ano completo realizado.}

\item{sequencial}{logic. Parâmetro que define se a projeção deve ser
realizada de forma sequencial ou paralela. Para executar a projeção de forma
sequencial defina o parâmetro como TRUE. Default FALSE.}

\item{filtro_de_uf}{string. Parâmetro que define uma unidade federativa (UF) a
ser filtrada. Caso uma UF não seja indicada ou seja informado um valor inválido,
o resultado será apresentado sem filtros.}

\item{filtro_nome4md}{string. Parâmetro que define o nome de uma concessionária
de energia a ser filtrado. Caso não seja informado um valor ou seja informado um
valor inválido o resultado será apresentado sem filtro.}

\item{filtro_de_segmento}{string. Parâmetro que define um segmento a ser
filtrado. Pode se escolher entre "comercial_at", "comercial_at_remoto",
"comercial_bt", "residencial" e "residencial_remoto".  Caso não seja
informado um valor ou seja informado um valor inválido o resultado será
apresentado sem filtro.}

\item{filtro_de_custo_unitario_max}{numeric. Parâmetro que define o valor
máximo do custo unitário para ser utilizado no cálculo do payback. Default
igual a NULL.}

\item{ano_max_resultado}{numeric. Ano final para apresentação dos resultados.
Máximo igual a 2050. Default igual a 2050.}

\item{altera_sistemas_existentes}{logic. TRUE se alterações regulatórias
afetam investimentos realizados em anos anteriores à revisão da regulação.
Default igual a FALSE.}

\item{ano_decisao_alteracao}{numeric. Ano em que são definidas novas regras e
se tornam de conhecimento público. Esse parâmetro só tem efeito caso o
anterior seja igual a TRUE. Default igual a 2023.}

\item{inflacao}{mumeric. Taxa anual de inflacao considerada no reajuste das
tarifas e para calcular o retorno real de projetos. Default igual a 0.0375.}

\item{taxa_desconto_nominal}{numeric. Taxa de desconto nominal considerada
nos cálculos de payback descontado. Default igual a 0.13.}

\item{custo_reforco_rede}{numeric. Custo em R$/kW aplicado a projetos de
geracao remota em Alta Tensão. Representa um custo pago pelo empreendedor
para reforços na rede. Default igual a 200.}

\item{ano_troca_inversor}{numeric. Ano, a partir do ano de instalação, em que
é realizada a troca do inversor fotovoltaico. Default igual a 11.}

\item{pagamento_disponibilidade}{numeric. Percentual de meses em que o
consumidor residencial paga custo de disponbilidade em função da
variabilidade da geração FV. Default igual a 0.3.}

\item{disponibilidade_kwh_mes}{numeric. Consumo de disponbilidade do
consumidor em kWh/mês. Default igual a 100, equivalente a um consumidor
trifásico.}

\item{filtro_renda_domicilio}{string. Define o filtro aplicado a consumidores
residenciais, de acordo com a renda mensal do responsável, em salários
mínimos. Permite: "total", "maior_1sm", maior_2sm", "maior_3sm" ou
"maior_5sm". Default igual a "maior_3sm".}

\item{desconto_capex_local}{numeric. Percentual de desconto a ser aplicado no
CAPEX de sistemas de geração local(ex: 0.1) para simulação de incentivos.
Default igual a 0.}

\item{anos_desconto}{vector. Anos em que há a incidência do desconto no
CAPEX. Default igual a 0.}

\item{tx_cresc_grupo_a}{numeric. Taxa de crescimento anual dos consumidores
cativos do Grupo A. Default igual a 0.016 representa crescimento entre
2006 e 2019.}

\item{spb}{numeric. Fator de Sensibilidade ao Payback (SPB).
Default igual a 0.3.}

\item{p_max}{numeric. Fator de inovação (p) máximo. Default igual a 0.01.}

\item{q_max}{numeric. Fator de imitação (q) máximo. Default igual a 1.}

\item{filtro_comercial}{numeric. Fator percentual para definir o nicho do
segmento comercial. Default é calculado pelo modelo com base no nicho
residencial.}

\item{ajuste_ano_corrente}{logic. Se TRUE indica que a projeção deverá
incorporar o histórico mensal recente, verificado em parte do primeiro ano
após o ano base. Default igual a FALSE. O arquivo base_mmgd.xlsx deve
incorporar esse histórico.}

\item{ultimo_mes_ajuste}{numeric. Último mês com dados completos na
base_ano_corrente. Default igual a NA. Só tem efeito caso ajuste_ano_corrente
seja igual a TRUE.}

\item{metodo_ajuste}{string. Se igual a "extrapola" o modelo irá extrapolar a
potência e o número de adotantes até o final do ano base + 1 com base no
verificado até o ultimo_mes_ajuste. Default igual a NA. Só tem efeito caso
ajuste_ano_corrente seja igual a TRUE.}

\item{dir_dados_premissas}{Diretório onde se encontram as premissas. Se esse
parâmetro não for passado, a função usa os dados default que são instalados
com o pacote. É importante que os nomes dos arquivos sejam os mesmos da
pasta default.}
}
\value{
data.frame com os resultados da projeção de capacidade instalada
de micro e minigeração distribuída, número de adotantes e geração
mensal de energia.
}
\description{
O resultado do modelo 4MD são projeções de capacidade instalada, número de
adotantes e geração de energia em base mensal.
}
\examples{
  \donttest{
    premissas_regulatorias <- structure(
    list(ano = 2021,
         alternativa = 0,
         p_transicao = 1,
         binomia = FALSE,
         demanda_g = FALSE),
    class = c("tbl_df", "tbl", "data.frame"),
    row.names = c(NA, -1L)
    )

    resultado <- epe4md_calcula(premissas_reg = premissas_regulatorias,
                                ano_base = 2021,
                                sequencial = FALSE,
                                filtro_de_uf = "RR",
                                filtro_de_segmento = "comercial_at",
                                filtro_de_custo_unitario_max = 6,
                                ano_max_resultado = 2021)
  }
}
