% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gamma_tools.R
\name{gamma_shapescale2mucv}
\alias{gamma_shapescale2mucv}
\alias{gamma_mucv2shapescale}
\alias{gamma_log_likelihood}
\title{Reparameterise Gamma distributions}
\usage{
gamma_shapescale2mucv(shape, scale)

gamma_mucv2shapescale(mu, cv)

gamma_log_likelihood(
  x,
  mu,
  cv,
  discrete = TRUE,
  interval = 1,
  w = 0,
  anchor = 0.5
)
}
\arguments{
\item{shape}{The shape parameter of the Gamma distribution.}

\item{scale}{The scale parameter of the Gamma distribution.}

\item{mu}{The mean of the Gamma distribution.}

\item{cv}{The coefficient of variation of the Gamma distribution, i.e. the
standard deviation divided by the mean.}

\item{x}{A vector of data treated as observations drawn from a Gamma
distribution, for which the likelihood is to be computed.}

\item{discrete}{A logical indicating if the distribution should be
discretised; TRUE by default.}

\item{interval}{The interval used for discretisation; see
\code{\link[distcrete]{distcrete}}.}

\item{w}{The centering of the interval used for discretisation, defaulting to
0; see \code{\link[distcrete]{distcrete}}.}

\item{anchor}{The anchor used for discretisation, i.e. starting point of the
discretisation process; defaults to 0; see
\code{\link[distcrete]{distcrete}}.}
}
\value{
A named list containing 'shape' and 'scale', or mean ('mean') and
coefficient of variation ('cv').
}
\description{
These functions permit to use alternate parametrisations for Gamma
distributions, from 'shape and scale' to 'mean (mu) and coefficient of
variation (cv), and back. \code{gamma_shapescale2mucv} does the first
conversion, while \code{gamma_mucv2shapescale} does the second. The function
\code{gamma_log_likelihood} is a shortcut for computing Gamma log-likelihood
with the alternative parametrisation (mean, cv). See 'details' for a guide of
which parametrisation to use.#'
}
\details{
The gamma distribution is described in \code{\link{dgamma}} is
parametrised using shape and scale (or rate). However, these parameters are
naturally correlated, which make them poor choices whenever trying to fit
data to a Gamma distribution. Their interpretation is also less clear than
the traditional mean and variance. When fitting the data, or reporting
results, it is best to use the alternative parametrisation using the mean
(\code{mu}) and the coefficient of variation (\code{cv}), i.e. the standard
deviation divided by the mean.
}
\examples{

## set up some parameters

mu <- 10
cv <- 1


## transform into shape scale

tmp <- gamma_mucv2shapescale (mu, cv)
shape <- tmp$shape
scale <- tmp$scale


## recover original parameters when applying the revert function

gamma_shapescale2mucv(shape, scale) # compare with mu, cv


## empirical validation:
## check mean / cv of a sample derived using rgamma with
## shape and scale computed from mu and cv

gamma_sample <- rgamma(n = 10000, shape = shape, scale = scale)
mean(gamma_sample) # compare to mu
sd(gamma_sample) / mean(gamma_sample) # compare to cv
}
\author{
Code by Anne Cori \email{a.cori@imperial.ac.uk}, packaging by
Thibaut Jombart \email{thibautjombart@gmail.com}
}
