% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{preview_eq}
\alias{preview_eq}
\title{Preview an equation in a web browser}
\usage{
preview_eq(x, ...)
}
\arguments{
\item{x}{'LaTeX' equation built with \code{\link{extract_eq}}}

\item{...}{not used}
}
\value{
The path to the temporary html file that was created to preview the
equation is returned invisibly.
}
\description{
Preview 'LaTeX' equations built with \code{\link{extract_eq}}.
}
\examples{
if (interactive()) {
  mod1 <- lm(mpg ~ cyl + disp, mtcars)
  eq1 <- extract_eq(mod1)
  eq1 # Not that nice
  preview_eq(eq1)
  # or easier...
  preview_eq(mod1)
}
}
