% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kgaps_methods.R
\name{kgaps_methods}
\alias{kgaps_methods}
\alias{coef.kgaps}
\alias{vcov.kgaps}
\alias{nobs.kgaps}
\alias{logLik.kgaps}
\alias{print.kgaps}
\alias{summary.kgaps}
\alias{print.summary.kgaps}
\title{Methods for objects of class \code{"kgaps"}}
\usage{
\method{coef}{kgaps}(object, ...)

\method{vcov}{kgaps}(object, type = c("observed", "expected"), ...)

\method{nobs}{kgaps}(object, ...)

\method{logLik}{kgaps}(object, ...)

\method{print}{kgaps}(x, digits = max(3L, getOption("digits") - 3L), ...)

\method{summary}{kgaps}(
  object,
  se_type = c("observed", "expected"),
  digits = max(3, getOption("digits") - 3L),
  ...
)

\method{print}{summary.kgaps}(x, ...)
}
\arguments{
\item{object}{and object of class \code{c("kgaps", "exdex")} returned from
\code{\link{kgaps}}.}

\item{...}{For \code{print.summary.kgaps}, additional arguments passed to
\code{\link{print.default}}.}

\item{type}{A character scalar. Should the estimate of the variance be based
on the observed information or the expected information?}

\item{x}{\code{print.kgaps}. An object of class \code{c("kgaps", "exdex")}, a
  result of a call to \code{\link{kgaps}}.

  \code{print.summary.kgaps}. An object of class \code{"summary.kgaps"}, a
  result of a call to \code{\link{summary.kgaps}}.}

\item{digits}{\code{print.kgaps}. The argument \code{digits} to
  \code{\link{print.default}}.

  \code{summary.kgaps}. An integer. Used for number formatting with
  \code{\link[base:Round]{signif}}.}

\item{se_type}{A character scalar. Should the estimate of the standard error
be based on the observed information or the expected information?}
}
\value{
\code{coef.kgaps}. A numeric scalar: the estimate of the extremal index
  \eqn{\theta}.

  \code{vcov.kgaps}. A \eqn{1 \times 1}{1 x 1} numeric matrix containing the
  estimated variance of the estimator.

  \code{nobs.kgaps}. A numeric scalar: the number of inter-exceedance times
  used in the fit. If \code{x$inc_cens = TRUE} then this includes up to 2
  censored observations.

  \code{logLik.kgaps}. An object of class \code{"logLik"}: a numeric scalar
  with value equal to the maximised log-likelihood.  The returned object
  also has attributes \code{nobs}, the numbers of \eqn{K}-gaps that
  contribute to the log-likelihood and \code{"df"}, which is equal to the
  number of total number of parameters estimated (1).

  \code{print.kgaps}. The argument \code{x}, invisibly.

  \code{summary.kgaps}. Returns a list containing the list element
  \code{object$call} and a numeric matrix \code{summary} giving the estimate
  of the extremal index \eqn{\theta} and the estimated standard error
  (Std. Error).

  \code{print.summary.kgaps}. The argument \code{x}, invisibly.
}
\description{
Methods for objects of class \code{c("kgaps", "exdex")} returned from
\code{\link{kgaps}}.
}
\section{Examples}{

See the examples in \code{\link{kgaps}}.
}

\seealso{
\code{\link{kgaps}} for maximum likelihood estimation of the
  extremal index \eqn{\theta} using the \eqn{K}-gaps model.

\code{\link{confint.kgaps}} for confidence intervals for
  \eqn{\theta}.
}
