% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests_psychotools.R
\name{LRtest.psy}
\alias{LRtest.psy}
\title{itemfit statistics for 'psychotools'
Anderson's likelihood ratio test for 'psychotools'}
\usage{
LRtest.psy(model, modelType, splitcr = "median", splitseed = NULL)
}
\arguments{
\item{model}{an object of 'psychotools' class 'raschmodel', 'pcmodel' or
'rsmodel'  (a model previously fit using the 'psychotools' package)
 matching the value of modelType.}

\item{modelType}{a character value defining the type of Rasch model.
Possible values: "RM", "PCM", "RSM"}

\item{splitcr}{Split criterion for subject raw score splitting for
test_LR. "median" uses the median as split criterion, "mean" performs a
  mean split, "random" performs a random split (in this case, the seed
  can be set with the "splitseed" argument. splitcr can also be a
  vector which assigns each person to a certain subgroup (typically an
  external criterion). This vector can be numeric, character or a factor.}

\item{splitseed}{seed for random split}
}
\value{
the p-value of the likelihood-ratio test.
}
\description{
itemfit statistics for 'psychotools'
Anderson's likelihood ratio test for 'psychotools'
}
\examples{
 model <- psychotools::raschmodel(ADL[c(6,7,12,14,15)])
 LRtest.psy(model=model, modelType="RM", splitcr="random", splitseed=332)
}
