% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_PSI.R
\name{test_PSI}
\alias{test_PSI}
\title{runs a principal component analysis (PCA) on the residuals of the
 rasch model.}
\usage{
test_PSI(
  items = NULL,
  dset = NULL,
  na.rm = TRUE,
  model = NULL,
  p.par = NULL,
  modelType = NULL,
  PSI = NULL,
  estimation_param = NULL
)
}
\arguments{
\item{items}{a numeric vector containing the index numbers of the items
in dset that are used to fit the model}

\item{dset}{a data.frame containing the data}

\item{na.rm}{a boolean value. If TRUE, all cases with any NA are removed
(na.omit). If FALSE, only cases with full NA responses are removed}

\item{model}{on object of a fit Rasch model, estimated with the packages
'eRm' (classes 'RM', 'PCM' or 'RSM'), 'psychotools' (classes raschmodel,
'pcmodel' or 'rsmodel') or 'pairwise' (class 'pers'), matching the value of
 modelType. If 'model' is provided, this model is used. If NULL, a model is
 fit using 'dset' and 'items'.}

\item{p.par}{a person parameter object matching the class of 'model'. If
NULL, the person parameters will be estimated.}

\item{modelType}{a character value defining the rasch model to fit.
Possible values: "RM", "PCM", "RSM".}

\item{PSI}{a numeric value defining the minimum value for the person-
separation-index (separation reliablility).}

\item{estimation_param}{options for parameter estimation using
\link{estimation_control}}
}
\value{
if the value of the PSI for the model is >= the PSI argument,
 a list containing 3 elements is returned: the item combination that was
 tested, a list of the class the model was estimated with (depending on
 modelType and estimation_param$est) with the fit model and a list with a
 person parameter object (depending on estimation_param$est). Else, NULL
 is returned.
}
\description{
runs a principal component analysis (PCA) on the residuals of the
 rasch model.
}
\keyword{internal}
