% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomize.R
\name{randomize}
\alias{randomize}
\alias{Randomize}
\title{Randomization of the Treatment Assignment for Conducting Experiments}
\usage{
randomize(
  data,
  group = c("Treat", "Control"),
  ratio = NULL,
  indx = NULL,
  block = NULL,
  n.block = NULL,
  match = NULL,
  complete = TRUE
)
}
\arguments{
\item{data}{A data frame containing the observations to which the treatments
are randomly assigned.}

\item{group}{A numerical or character vector indicating the
treatment/control groups. The length of the vector equals the total number
of such groups. The default specifies two groups called \dQuote{Treat} and
\dQuote{Control}.}

\item{ratio}{An optional numerical vector which specifies the proportion of
the treatment/control groups within the sample. The length of the vector
should equal the number of groups. The default is the equal allocation.}

\item{indx}{An optional variable name in the data frame to be used as the
names of the observations. If not specified, the row names of the data frame
will be used so long as they are available. If the row names are not
available, the integer sequence starting from 1 will be used.}

\item{block}{An optional variable name in the data frame or a formula to be
used as the blocking variables for randomized-block designs. If a variable
name is specified, then the unique values of that variable will form blocks
unless \code{n.block} is specified (see below). If a formula is specified,
it will be evaluated using \code{data} and then blocking will be based on
the \code{mahalanobis} distance of the resulting model matrix. In this case,
users may want to specify \code{n.block} to avoid creating blocks that have
too few observations.}

\item{n.block}{An optional scalar specifying the number of blocks to be
created for randomized block designs. If unspecified, the unique values of
the blocking variable will define blocks. If specified, the blocks of
roughly equal size will be created based on the \code{quantile} of the
blocking variable.}

\item{match}{An optional variable name in the data frame or a formula to be
used as the matching variables for matched-pair designs. This input is
applicable only to the case where there are two groups. Pairs of
observations will be formed based on the similar values of the matching
variable. If a formula is specified, the \code{mahalanobis} distance of the
resulting model matrix will be used.}

\item{complete}{logical. If it equals \code{TRUE} (default), then complete
randomization will be performed (within each block if randomized block
designs are used). Otherwise, simple randomization will be implemented. For
matched-pair designs, \code{complete} has to equal \code{TRUE}.}
}
\value{
A list of class \code{randomize} which contains the following items:
\item{call}{ the matched call.  } \item{treatment}{ The vector of randomized
treatments.  } \item{data}{ The data frame that was used to conduct the
randomization.  } \item{block}{ The blocking variable that was used to
implement randomized-block designs.  } \item{match}{ The matching variable
that was used to implement matched-pair designs.  } \item{block.id}{ The
variable indicating which observations belong to which blocks in
randomized-block designs.  } \item{match.id}{ The variable indicating which
observations belong to which pairs in matched-pair designs.  }
}
\description{
This function can be used to randomize the treatment assignment for
randomized experiments. In addition to the complete randomization, it
implements randomized-block and matched-pair designs.
}
\details{
Randomized-block designs refer to the complete randomization of the
treatment within the pre-specified blocks which contain multiple
observations. Matched-pair designs refer to the randomization of the binary
treatment variable within the pre-specified pair of observations.
}
\author{
Kosuke Imai, Department of Government and Department of Statistics, Harvard University
\email{imai@Harvard.Edu}, \url{https://imai.fas.harvard.edu};
}
\keyword{design}
