% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batchMark.R
\name{batchMarkHmmLL}
\alias{batchMarkHmmLL}
\title{Log-likelihood function for marked model.}
\usage{
batchMarkHmmLL(
  par = NULL,
  data,
  covariate_phi = NULL,
  covariate_p = NULL,
  choiceModel = c("model1", "model2", "model3", "model4")
)
}
\arguments{
\item{par}{Initial values for the parameters to be optimized over.}

\item{data}{A capture-recapture data matrix or data frame.}

\item{covariate_phi}{This covariate placeholder for the parameter phi_t}

\item{covariate_p}{This covariate placeholder for the parameter p_t}

\item{choiceModel}{This chooses among different models and allows for model selection}
}
\value{
Negative Log-likelihood value of the likelihood function
}
\description{
This helps users check whether the function can be optimized at the given initial values before optimizing using \code{\link{batchMarkOptim}}. After a quick check, if \code{NAN} or \code{Inf} is returned, the initial values should be revisited.
}
\examples{
library(extBatchMarking)
# Initial parameter
theta <- c(0, -1)
res1  <- batchMarkHmmLL(par          = theta,
                       data          = WeatherLoach,
                       choiceModel   = "model4",
                       covariate_phi = NULL,
                       covariate_p   = NULL)
res1

}
