% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accuracy.R
\name{skill_score}
\alias{skill_score}
\title{Forecast skill score measure}
\usage{
skill_score(measure)
}
\arguments{
\item{measure}{The accuracy measure to use in computing the skill score.}
}
\description{
This function converts other error metrics such as \code{MSE} into a skill score.
The reference or benchmark forecasting method is the Naive method for
non-seasonal data, and the seasonal naive method for seasonal data.
When used within \code{\link{accuracy.fbl_ts}}, it is important that the data
contains both the training and test data, as the training data is used to
compute the benchmark forecasts.
}
\examples{

skill_score(MSE)

\dontshow{if (requireNamespace("fable", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(fable)
library(tsibble)

lung_deaths <- as_tsibble(cbind(mdeaths, fdeaths))
lung_deaths \%>\% 
  dplyr::filter(index < yearmonth("1979 Jan")) \%>\%
  model(
    ets = ETS(value ~ error("M") + trend("A") + season("A")),
    lm = TSLM(value ~ trend() + season())
  ) \%>\%
  forecast(h = "1 year") \%>\%
  accuracy(lung_deaths, measures = list(skill = skill_score(MSE)))
\dontshow{\}) # examplesIf}
}
