% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nckqr-methods.R
\name{predict.nckqr}
\alias{predict.nckqr}
\title{Predict the fitted values for a \code{nckqr} object.}
\usage{
\method{predict}{nckqr}(object, x, newx = NULL, s2, s1 = NULL, ...)
}
\arguments{
\item{object}{A fitted \code{nckqr} object.}

\item{x}{The predictor matrix, i.e., the \code{x} matrix used when fitting the \code{nckqr} object.}

\item{newx}{A matrix of new values for \code{x} at which predictions are to be made. Note
that \code{newx} must be of a matrix form, predict function does not accept a vector or other
formats of \code{newx}.}

\item{s2}{Value of the penalty parameter `lambda2` at which
predictions are required.}

\item{s1}{Value(s) of the penalty parameter `lambda1` at which
predictions are required. Default is the entire sequence used to create the
model.}

\item{...}{Not used.}
}
\value{
Returns the fitted values for the non-crossing kernel quantile regression model.
}
\description{
Predict the fitted values for a \code{nckqr} object.
}
\examples{
library(MASS)
data(GAGurine)
x <- as.matrix(GAGurine$Age)
y <- GAGurine$GAG
l2 <- 1e-4
ttau <- c(0.1, 0.3, 0.5, 0.7, 0.9)
l1_list <- 10^seq(-8, 2, length.out=10)
\donttest{fit <- nckqr(x,y, lambda1=l1_list, lambda2=l2, tau=ttau)}
\donttest{predict(fit, x, tail(x), s1=l1_list[1:3], s2=1e-4)}
}
\keyword{kernel}
\keyword{regression}
