% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ice.R
\name{plot_ice}
\alias{plot_ice}
\title{Plot ICE curves for a fastml model}
\usage{
plot_ice(object, features, ...)
}
\arguments{
\item{object}{A `fastml` object.}

\item{features}{Character vector of feature names to plot.}

\item{...}{Additional arguments passed to `pdp::partial`.}
}
\value{
A `ggplot` object displaying ICE curves.
}
\description{
Generates Individual Conditional Expectation (ICE) plots for selected features
using the `pdp` package.
}
\examples{
\dontrun{
data(iris)
iris <- iris[iris$Species != "setosa", ]
iris$Species <- factor(iris$Species)
model <- fastml(data = iris, label = "Species")
plot_ice(model, features = "Sepal.Length")
}
}
