% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequency.R
\name{add_l2nm}
\alias{add_l2nm}
\alias{add_l2sq}
\alias{get_l2nm}
\alias{get_l2sq}
\title{Add L2 Norm and Squared L2 Norm of Frequency Dimensions}
\usage{
add_l2nm(x)

add_l2sq(x)

get_l2nm(x)

get_l2sq(x)
}
\arguments{
\item{x}{A \code{fftab} object containing frequency dimensions (\verb{.dim_*}) and associated metadata.}
}
\value{
A vector or \code{fftab} object with additional columns:
\itemize{
\item \strong{\code{l2nm}}: The L2 norm of the frequency dimensions.
\item \strong{\code{l2sq}}: The squared L2 norm of the frequency dimensions.
}
}
\description{
These functions compute and append the L2 norm and squared L2 norm of the frequency dimensions
(\verb{.dim_*} columns) as new columns in a \code{fftab} object.
}
\details{
\itemize{
\item \strong{\code{add_l2nm()}}: Appends a column \code{l2nm} containing the L2 norm, calculated as the square root
of the sum of squared values across \verb{.dim_*} columns.
\item \strong{\code{add_l2sq()}}: Appends a column \code{l2sq} containing the squared L2 norm, calculated as the sum
of squared values across \verb{.dim_*} columns.
\item \strong{\code{get_l2nm()}}: Returns a numeric vector representing the L2 norm for each row.
\item \strong{\code{get_l2sq()}}: Returns a numeric vector representing the squared L2 norm for each row.
}
}
\examples{
matrix(1:9, 3) |>
  fftab() |>
  print(n = 3) |>
  add_l2nm() |>
  print(n = 3) |>
  add_l2sq() |>
  print(n = 3)

}
\seealso{
\itemize{
\item \code{\link[=fftab]{fftab()}}
\item \code{\link[tibble:add_column]{tibble::add_column()}}
}
}
