% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{findGSE_sp}
\alias{findGSE_sp}
\title{Estimate Genome Size Using K-mer Frequencies}
\usage{
findGSE_sp(
  histo = "",
  sizek = 0,
  outdir = "",
  exp_hom = 0,
  species = "",
  ploidy_ind = 2,
  avg_cov = 0,
  left_fit_ratio = 0.835,
  meanfit_old = 0,
  sdfit_old = 0,
  scale_flag = FALSE
)
}
\arguments{
\item{histo}{A character string specifying the path to the histogram file.}

\item{sizek}{An integer indicating the size of k used to generate the histogram.}

\item{outdir}{A character string specifying the output directory. If not specify, will use tempdir() as output directory.}

\item{exp_hom}{A numeric value representing the expected average k-mer coverage for the homozygous regions.}

\item{species}{A character string specifying the species name.}

\item{ploidy_ind}{An integer indicating the ploidy index (default is 2).}

\item{avg_cov}{A numeric value representing the average coverage.}

\item{left_fit_ratio}{A numeric value for the left fit ratio (default is 0.835).}

\item{meanfit_old}{A numeric value representing the previous mean fit.}

\item{sdfit_old}{A numeric value representing the previous standard deviation fit.}

\item{scale_flag}{A logical value indicating whether to apply scaling (default is FALSE).}
}
\value{
A list containing the estimated genome size and other fitting parameters.
}
\description{
This function estimates the genome size of a species using k-mer frequencies.
}
\examples{
\dontrun{

histo <- "sample1.histo"
sizek <- 21
outdir <- tempdir()
exp_hom <- 200
species <- ""
ploidy_ind <- 2
avg_cov <- 0
left_fit_ratio <- 0.835
meanfit_old <- 0
sdfit_old <- 0
scale_flag <- FALSE
fit_lists <- findGSE_sp(path, samples, sizek, exp_hom, ploidy, range_left,
 range_right, xlimit, ylimit, output_dir)
}
}
