% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{select_tracers}
\alias{select_tracers}
\title{Select specific tracers from a data frame}
\usage{
select_tracers(data, tracers)
}
\arguments{
\item{data}{A data frame containing tracer data.}

\item{tracers}{A character vector of tracers to select.}
}
\value{
A data frame containing only the specified tracer columns. The returned columns
will be selected based on the data format. For non-isotopic and raw data, it selects
the tracer columns (e.g., "tracer1"). For non-isotopic and averaged data, it selects
the mean and standard deviation columns (e.g., "mean_tracer1", "sd_tracer1"). For
isotopic and raw data, it selects the tracer and its corresponding concentration column
(e.g., "tracer1", "cont_tracer1"). For isotopic and averaged data, it selects the mean
and standard deviation for both the tracer and its concentration (e.g., "mean_tracer1",
"mean_cont_tracer1", "sd_tracer1", "sd_cont_tracer1").
}
\description{
This function allows you to select a subset of tracer columns from a data frame.
It is designed to work with both isotopic and non-isotopic datasets, and also
with both averaged and raw data formats.
}
