% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_lik_occupancy.R
\name{log_lik_flocker}
\alias{log_lik_flocker}
\title{Compute unit-wise or series-wise log-likelihood matrix for a flocker_fit object}
\usage{
log_lik_flocker(flocker_fit, draw_ids = NULL)
}
\arguments{
\item{flocker_fit}{A flocker_fit object}

\item{draw_ids}{the draw ids to compute log-likelihoods for. Defaults to using the full posterior.}
}
\value{
A posterior log-likelihood matrix, where iterations are rows and 
   units, series, or species are columns.
}
\description{
Compute unit-wise or series-wise log-likelihood matrix for a flocker_fit object
}
\details{
In single-season models, rows are units (e.g. points or 
  species-points; suitable for leave-one-unit-out CV). In multiseason models, 
  rows are series (i.e. points or species-points, suitable for 
  leave-one-series-out CV). In augmented models, rows are species (suitable
  for leave-one-species-out CV).
}
\examples{
log_lik_flocker(example_flocker_model_single)
}
