% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moment.R
\name{moment2fmx}
\alias{moment2fmx}
\title{Creates \linkS4class{fmx} Object with Given Component-Wise Moments}
\usage{
moment2fmx(distname, w, ...)
}
\arguments{
\item{distname}{\link[base]{character} scalar}

\item{w}{\link[base]{numeric} \link[base]{vector}}

\item{...}{\link[base]{numeric} scalars,
some or all of \code{mean}, \code{sd}, \code{skewness} and \code{kurtosis}
(length will be recycled), see \link[param2moment]{moment2param}}
}
\value{
Function \code{\link[=moment2fmx]{moment2fmx()}} returns a \linkS4class{fmx} object.
}
\description{
Creates \linkS4class{fmx} Object with Given Component-Wise Moments
}
\examples{
m = c(-1.5, 1.5)
s = c(.9, 1.1)
sk = c(.2, -.3)
kt = c(.5, .75)
w = c(2, 3)
(d1 = moment2fmx(distname='GH', w=w, mean=m, sd=s, skewness=sk, kurtosis=kt))
moment_fmx(d1)
(d2 = moment2fmx(distname='st', w=w, mean=m, sd=s, skewness=sk, kurtosis=kt))
moment_fmx(d2)
library(ggplot2)
ggplot() + 
 geom_function(aes(color = 'GH'), fun = dfmx, args = list(dist=d1), n = 1001) + 
 geom_function(aes(color = 'st'), fun = dfmx, args = list(dist=d1), n = 1001) +
 xlim(-5, 6)
# two curves looks really close, but actually not identical
x = rfmx(n = 1e3L, dist = d1)
range(dfmx(x, dist = d1) - dfmx(x, dist = d2))

}
