% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ae_forestly.R
\name{ae_forestly}
\alias{ae_forestly}
\title{Display interactive forest plot}
\usage{
ae_forestly(
  outdata,
  display_soc_toggle = TRUE,
  filter = c("prop", "n"),
  filter_label = NULL,
  filter_range = NULL,
  width = 1400,
  max_page = NULL
)
}
\arguments{
\item{outdata}{An \code{outdata} object created by \code{\link[=format_ae_forestly]{format_ae_forestly()}}.}

\item{display_soc_toggle}{A boolean value to display SOC toggle button.}

\item{filter}{A character value of the filter variable.}

\item{filter_label}{A character value of the label for slider bar.}

\item{filter_range}{A numeric vector of length 2 for the range of the slider bar.
If NULL (default), the range is automatically calculated from the data.
If only one value is provided, it will be used as the maximum and minimum will be 0.}

\item{width}{A numeric value of width of the table in pixels.}

\item{max_page}{A numeric value of max page number shown in the table.}
}
\value{
An AE forest plot saved as a \code{shiny.tag.list} object.
}
\description{
Display interactive forest plot
}
\examples{
adsl <- forestly_adsl[1:100, ]
adae <- forestly_adae[1:100, ]
if (interactive()) {
  meta_forestly(
    dataset_adsl = adsl,
    dataset_adae = adae,
  ) |>
    prepare_ae_forestly() |>
    format_ae_forestly() |>
    ae_forestly()
}
}
