% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docs_export.R
\name{docs_export}
\alias{docs_export}
\title{Export Package Documentation to Database}
\usage{
docs_export(
  output_path = "docs.db",
  man_dir = "man",
  package_name = "framework",
  package_version = NULL,
  include_internal = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{output_path}{Path to SQLite database file. Default: "docs.db"}

\item{man_dir}{Directory containing .Rd files. Default: "man"}

\item{package_name}{Package name for metadata. Default: "framework"}

\item{package_version}{Package version for metadata. Default: NULL (auto-detect)}

\item{include_internal}{Include internal/non-exported functions. Default: FALSE}

\item{verbose}{Print progress messages. Default: TRUE}
}
\value{
Invisibly returns the database connection path
}
\description{
Parses roxygen2-generated .Rd files and exports structured documentation
to SQLite (for GUI) or other formats. This enables searchable documentation
in the Framework GUI and powers the public documentation website.
}
\details{
The exporter reads all .Rd files from the man/ directory and extracts:
\itemize{
\item Function name, title, description, details
\item Arguments/parameters with descriptions
\item Usage signatures
\item Examples (with dontrun detection)
\item See Also references
\item Custom sections and subsections
\item Keywords
}

The SQLite output includes FTS5 full-text search for fast querying.
}
\examples{
\donttest{
if (FALSE) {
# Export to default location (exported functions only)
docs_export()

# Export to custom location
docs_export("inst/gui/docs.db")

# Include internal/private functions too
docs_export("all_docs.db", include_internal = TRUE)

# Query the exported docs
con <- DBI::dbConnect(RSQLite::SQLite(), "docs.db")
DBI::dbGetQuery(con, "SELECT name, title FROM functions WHERE name LIKE 'data_\%'")
DBI::dbDisconnect(con)
}
}

}
